/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.NotNullFactory;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.reference.SoftReference;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.NonExtendable
public abstract class NotNullLazyValue<T>
implements Supplier<T> {
    private T myValue;

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    protected NotNullLazyValue() {
    }

    @NotNull
    protected abstract T compute();

    @Override
    public final T get() {
        return this.getValue();
    }

    @NotNull
    public T getValue() {
        T result = this.myValue;
        if (result == null) {
            RecursionGuard.StackStamp stamp = RecursionManager.markStack();
            result = this.compute();
            if (stamp.mayCacheNow()) {
                this.myValue = result;
            }
        }
        return result;
    }

    public boolean isComputed() {
        return this.myValue != null;
    }

    @NotNull
    public static <T> NotNullLazyValue<T> createConstantValue(@NotNull T value) {
        return NotNullLazyValue.lazy(() -> value);
    }

    @NotNull
    public static <T> NotNullLazyValue<T> createValue(@NotNull NotNullFactory<? extends T> value) {
        return NotNullLazyValue.lazy(value::create);
    }

    @NotNull
    public static <T> NotNullLazyValue<T> lazy(final @NotNull Supplier<? extends T> value) {
        return new NotNullLazyValue<T>(){

            @Override
            @NotNull
            protected T compute() {
                return value.get();
            }
        };
    }

    @NotNull
    public static <T> NotNullLazyValue<T> atomicLazy(final @NotNull @NotNull Supplier<? extends @NotNull T> value) {
        return new AtomicNotNullLazyValue<T>(){

            @Override
            @NotNull
            protected T compute() {
                return value.get();
            }
        };
    }

    public static <T> Supplier<T> softLazy(final Supplier<? extends T> supplier) {
        return new Supplier<T>(){
            private java.lang.ref.SoftReference<T> ref;

            @Override
            public T get() {
                Object value = SoftReference.dereference(this.ref);
                if (value == null) {
                    value = supplier.get();
                    this.ref = new java.lang.ref.SoftReference(value);
                }
                return value;
            }
        };
    }

    @NotNull
    public static <T> NotNullLazyValue<T> volatileLazy(final @NotNull @NotNull Supplier<? extends @NotNull T> supplier) {
        return new NotNullLazyValue<T>(){
            private volatile T value;

            @Override
            @NotNull
            public T getValue() {
                Object value = this.value;
                if (value == null) {
                    RecursionGuard.StackStamp stamp = RecursionManager.markStack();
                    value = this.compute();
                    if (stamp.mayCacheNow()) {
                        this.value = value;
                    }
                }
                return value;
            }

            @Override
            public boolean isComputed() {
                return this.value != null;
            }

            @Override
            @NotNull
            protected T compute() {
                return supplier.get();
            }
        };
    }
}

