/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Debug;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
@Debug.Renderer(text="\"size = \" + myDelegate.size()", hasChildren="!isEmpty()", childrenArray="entrySet().toArray()")
@ApiStatus.ScheduledForRemoval
public class MultiValuesMap<K, V> {
    private final MultiMap<K, V> myDelegate;
    private final boolean myOrdered;

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public MultiValuesMap() {
        this(false);
    }

    public MultiValuesMap(boolean ordered) {
        this.myOrdered = ordered;
        this.myDelegate = ordered ? MultiMap.createLinkedSet() : new MultiMap<K, V>(){

            @Override
            @NotNull
            protected Collection<V> createCollection() {
                return new HashSet();
            }

            @Override
            @NotNull
            protected Collection<V> createEmptyCollection() {
                return Collections.emptySet();
            }
        };
    }

    public void putAll(K key, @NotNull Collection<? extends V> values) {
        for (V value : values) {
            this.put(key, value);
        }
    }

    public void putAll(K key, V ... values) {
        for (V value : values) {
            this.put(key, value);
        }
    }

    public void put(K key, V value) {
        this.myDelegate.putValue(key, value);
    }

    @Nullable
    public Collection<V> get(K key) {
        Collection<V> collection = this.myDelegate.get(key);
        return collection.isEmpty() ? null : collection;
    }

    @NotNull
    public Set<K> keySet() {
        return this.myDelegate.keySet();
    }

    @NotNull
    public Collection<V> values() {
        return this.myOrdered ? new LinkedHashSet<V>(this.myDelegate.values()) : new HashSet<V>(this.myDelegate.values());
    }

    public void remove(K key, V value) {
        this.myDelegate.remove(key, value);
    }

    public void clear() {
        this.myDelegate.clear();
    }

    @Nullable
    public Collection<V> removeAll(K key) {
        return this.myDelegate.remove(key);
    }

    @NotNull
    public Set<Map.Entry<K, Collection<V>>> entrySet() {
        return this.myDelegate.entrySet();
    }

    public boolean isEmpty() {
        return this.myDelegate.isEmpty();
    }

    public boolean containsKey(K key) {
        return this.myDelegate.containsKey(key);
    }

    @Nullable
    public V getFirst(K key) {
        Collection<V> values = this.myDelegate.get(key);
        return values.isEmpty() ? null : (V)values.iterator().next();
    }
}

