/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public final class LowMemoryWatcherManager
implements Disposable {
    private static final long MEM_THRESHOLD = 0x500000L;
    private final ExecutorService myExecutorService;
    private Future<?> mySubmitted;
    private final Future<?> myMemoryPoolMXBeansFuture;
    private final Consumer<Boolean> myJanitor = new Consumer<Boolean>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void accept(@NotNull Boolean afterGc) {
            Consumer consumer = LowMemoryWatcherManager.this.myJanitor;
            synchronized (consumer) {
                LowMemoryWatcherManager.this.mySubmitted = null;
            }
            LowMemoryWatcher.onLowMemorySignalReceived(afterGc);
        }
    };
    private final NotificationListener myLowMemoryListener = new NotificationListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleNotification(Notification notification, Object __) {
            if (LowMemoryWatcher.notificationsSuppressed()) {
                return;
            }
            boolean memoryThreshold = "java.management.memory.threshold.exceeded".equals(notification.getType());
            boolean memoryCollectionThreshold = "java.management.memory.collection.threshold.exceeded".equals(notification.getType());
            if (memoryThreshold || memoryCollectionThreshold) {
                Consumer consumer = LowMemoryWatcherManager.this.myJanitor;
                synchronized (consumer) {
                    if (LowMemoryWatcherManager.this.mySubmitted == null) {
                        LowMemoryWatcherManager.this.mySubmitted = LowMemoryWatcherManager.this.myExecutorService.submit(() -> LowMemoryWatcherManager.this.myJanitor.accept(memoryCollectionThreshold));
                        if (LowMemoryWatcherManager.this.mySubmitted.isDone()) {
                            LowMemoryWatcherManager.this.mySubmitted = null;
                        }
                    }
                }
            }
        }
    };

    @NotNull
    private static Logger getLogger() {
        return Logger.getInstance(LowMemoryWatcherManager.class);
    }

    public LowMemoryWatcherManager(@NotNull ExecutorService backendExecutorService) {
        this.myExecutorService = Boolean.getBoolean("low.memory.watcher.sync") ? ConcurrencyUtil.newSameThreadExecutorService() : SequentialTaskExecutor.createSequentialApplicationPoolExecutor("LowMemoryWatcherManager", backendExecutorService);
        this.myMemoryPoolMXBeansFuture = this.initializeMXBeanListenersLater(backendExecutorService);
    }

    @NotNull
    private Future<?> initializeMXBeanListenersLater(@NotNull ExecutorService backendExecutorService) {
        return backendExecutorService.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    for (MemoryPoolMXBean bean : ManagementFactory.getMemoryPoolMXBeans()) {
                        long max;
                        long threshold;
                        if (bean.getType() != MemoryType.HEAP || !bean.isCollectionUsageThresholdSupported() || !bean.isUsageThresholdSupported() || (threshold = Math.min((long)((float)(max = bean.getUsage().getMax()) * LowMemoryWatcherManager.getOccupiedMemoryThreshold()), max - 0x500000L)) <= 0L) continue;
                        bean.setUsageThreshold(threshold);
                        bean.setCollectionUsageThreshold(threshold);
                    }
                    ((NotificationEmitter)((Object)ManagementFactory.getMemoryMXBean())).addNotificationListener(LowMemoryWatcherManager.this.myLowMemoryListener, null, null);
                }
                catch (Throwable e) {
                    LowMemoryWatcherManager.getLogger().info("Errors initializing LowMemoryWatcher: ", e);
                }
            }

            public String toString() {
                return "initializeMXBeanListeners runnable";
            }
        });
    }

    private static float getOccupiedMemoryThreshold() {
        return SystemProperties.getFloatProperty("low.memory.watcher.notification.threshold", 0.95f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        try {
            this.myMemoryPoolMXBeansFuture.get();
            ((NotificationEmitter)((Object)ManagementFactory.getMemoryMXBean())).removeNotificationListener(this.myLowMemoryListener);
        }
        catch (Exception e) {
            LowMemoryWatcherManager.getLogger().error(e);
        }
        Consumer<Boolean> consumer = this.myJanitor;
        synchronized (consumer) {
            if (this.mySubmitted != null) {
                this.mySubmitted.cancel(false);
                this.mySubmitted = null;
            }
        }
        LowMemoryWatcher.stopAll();
    }

    @TestOnly
    public void waitForInitComplete(int timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.myMemoryPoolMXBeansFuture.get(timeout, unit);
    }
}

