/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.IntObjectMap;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NonNls
public class Key<T> {
    private static final AtomicInteger ourKeysCounter = new AtomicInteger();
    private static final IntObjectMap<Key<?>> allKeys = ContainerUtil.createIntKeyWeakValueMap();
    private final int myIndex = ourKeysCounter.getAndIncrement();
    private final String myName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Key(@NonNls @NotNull String name) {
        this.myName = name;
        IntObjectMap<Key<?>> intObjectMap = allKeys;
        synchronized (intObjectMap) {
            allKeys.put(this.myIndex, this);
        }
    }

    public final int hashCode() {
        return this.myIndex;
    }

    public final boolean equals(Object obj) {
        return obj == this;
    }

    public String toString() {
        return this.myName;
    }

    @NotNull
    public static <T> Key<T> create(@NonNls @NotNull String name) {
        return new Key<T>(name);
    }

    @Contract(value="null -> null")
    public T get(@Nullable UserDataHolder holder) {
        return holder == null ? null : (T)holder.getUserData(this);
    }

    @Contract(value="_, !null -> !null")
    public T get(@Nullable UserDataHolder holder, T defaultValue) {
        T t = this.get(holder);
        return t == null ? defaultValue : t;
    }

    @NotNull
    public T getRequired(@NotNull UserDataHolder holder) {
        return Objects.requireNonNull(holder.getUserData(this));
    }

    public boolean isIn(@Nullable UserDataHolder holder) {
        return this.get(holder) != null;
    }

    public void set(@Nullable UserDataHolder holder, @Nullable T value) {
        if (holder != null) {
            holder.putUserData(this, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable(value="can become null if the key has been gc-ed")
    public static <T> @Nullable(value="can become null if the key has been gc-ed") Key<T> getKeyByIndex(int index) {
        IntObjectMap<Key<?>> intObjectMap = allKeys;
        synchronized (intObjectMap) {
            return allKeys.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @Nullable
    public static Key<?> findKeyByName(@NotNull String name) {
        IntObjectMap<Key<?>> intObjectMap = allKeys;
        synchronized (intObjectMap) {
            for (Key<?> key : allKeys.values()) {
                if (!name.equals(key.myName)) continue;
                return key;
            }
            return null;
        }
    }
}

