/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.CheckedDisposable;
import com.intellij.openapi.util.ObjectTree;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class Disposer {
    private static final ObjectTree ourTree = new ObjectTree();
    private static boolean ourDebugMode;
    private static final Map<String, Disposable> ourKeyDisposables;

    public static boolean isDebugDisposerOn() {
        return "on".equals(System.getProperty("idea.disposer.debug"));
    }

    private Disposer() {
    }

    @NotNull
    @Contract(pure=true, value="->new")
    public static Disposable newDisposable() {
        return new Disposable(){

            @Override
            public void dispose() {
            }

            public String toString() {
                return "newDisposable";
            }
        };
    }

    @NotNull
    @Contract(pure=true, value="_->new")
    public static Disposable newDisposable(final @NotNull @NonNls String debugName) {
        return new Disposable(){

            @Override
            public void dispose() {
            }

            public String toString() {
                return debugName;
            }
        };
    }

    @NotNull
    @Contract(pure=true, value="->new")
    public static CheckedDisposable newCheckedDisposable() {
        return new CheckedDisposableImpl();
    }

    @Contract(pure=true, value="_,_->new")
    @NotNull
    public static Disposable newDisposable(@NotNull Disposable parentDisposable, @NotNull String debugName) {
        Disposable result = Disposer.newDisposable(debugName);
        Disposer.register(parentDisposable, result);
        return result;
    }

    public static void register(@NotNull Disposable parent, @NotNull Disposable child) throws IncorrectOperationException {
        RuntimeException e = ourTree.register(parent, child);
        if (e != null) {
            throw e;
        }
    }

    public static boolean tryRegister(@NotNull Disposable parent, @NotNull Disposable child) {
        return ourTree.register(parent, child) == null;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static void register(@NotNull Disposable parent, @NotNull Disposable child, @NonNls @NotNull String key) {
        Disposer.register(parent, child);
        Disposable v = Disposer.get(key);
        if (v != null) {
            throw new IllegalArgumentException("Key " + key + " already registered: " + v);
        }
        ourKeyDisposables.put(key, child);
        Disposer.register(child, new KeyDisposable(key));
    }

    @Deprecated
    public static boolean isDisposed(@NotNull Disposable disposable) {
        return ourTree.getDisposalInfo(disposable) != null;
    }

    @Deprecated
    public static boolean isDisposing(@NotNull Disposable disposable) {
        String message = "this method is deprecated and going to be removed soon. Please use isDisposed() instead";
        Logger.getInstance(Disposer.class).error(message);
        return Disposer.isDisposed(disposable);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static Disposable get(@NotNull String key) {
        String message = "this method is deprecated and going to be removed soon. Store and use your own Disposable instead";
        Logger.getInstance(Disposer.class).error(message);
        return ourKeyDisposables.get(key);
    }

    public static void dispose(@NotNull Disposable disposable) {
        Disposer.dispose(disposable, true);
    }

    @ApiStatus.Internal
    public static void disposeChildren(@NotNull Disposable disposable, @Nullable Predicate<? super Disposable> predicate) {
        ourTree.executeAllChildren(disposable, predicate);
    }

    public static void dispose(@NotNull Disposable disposable, boolean processUnregistered) {
        ourTree.executeAll(disposable, processUnregistered);
    }

    @NotNull
    public static ObjectTree getTree() {
        return ourTree;
    }

    public static void assertIsEmpty() {
        Disposer.assertIsEmpty(false);
    }

    public static void assertIsEmpty(boolean throwError) {
        if (ourDebugMode) {
            ourTree.assertIsEmpty(throwError);
        }
    }

    public static boolean setDebugMode(boolean debugMode) {
        if (debugMode) {
            debugMode = !"off".equals(System.getProperty("idea.disposer.debug"));
        }
        boolean oldValue = ourDebugMode;
        ourDebugMode = debugMode;
        return oldValue;
    }

    public static boolean isDebugMode() {
        return ourDebugMode;
    }

    public static Throwable getDisposalTrace(@NotNull Disposable disposable) {
        return ObjectUtils.tryCast(Disposer.getTree().getDisposalInfo(disposable), Throwable.class);
    }

    @TestOnly
    @Nullable
    public static Throwable getRegistrationTrace(@NotNull Disposable disposable) {
        return Disposer.getTree().getRegistrationTrace(disposable);
    }

    @ApiStatus.Internal
    public static void clearDisposalTraces() {
        ourTree.clearDisposedObjectTraces();
    }

    static {
        ourKeyDisposables = ContainerUtil.createConcurrentWeakMap();
    }

    private static final class KeyDisposable
    implements Disposable {
        @NotNull
        private final String myKey;

        KeyDisposable(@NotNull String key) {
            this.myKey = key;
        }

        @Override
        public void dispose() {
            ourKeyDisposables.remove(this.myKey);
        }

        public String toString() {
            return "KeyDisposable (" + this.myKey + ")";
        }
    }

    static class CheckedDisposableImpl
    implements CheckedDisposable {
        volatile boolean isDisposed;

        CheckedDisposableImpl() {
        }

        @Override
        public boolean isDisposed() {
            return this.isDisposed;
        }

        @Override
        public void dispose() {
            this.isDisposed = true;
        }

        public String toString() {
            return "CheckedDisposableImpl{isDisposed=" + this.isDisposed + "} " + super.toString();
        }
    }
}

