/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.AtomicClearableLazyValue;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public abstract class ClearableLazyValue<T> {
    private T myValue;

    @NotNull
    public static <T> ClearableLazyValue<T> create(final @NotNull Supplier<? extends T> computable) {
        return new ClearableLazyValue<T>(){

            @Override
            @NotNull
            protected T compute() {
                return computable.get();
            }
        };
    }

    @NotNull
    public static <T> ClearableLazyValue<T> createAtomic(final @NotNull Supplier<? extends T> computable) {
        return new AtomicClearableLazyValue<T>(){

            @Override
            @NotNull
            protected T compute() {
                return computable.get();
            }
        };
    }

    @NotNull
    protected abstract T compute();

    @NotNull
    public T getValue() {
        T result = this.myValue;
        if (result == null) {
            RecursionGuard.StackStamp stamp = RecursionManager.markStack();
            result = this.compute();
            if (stamp.mayCacheNow()) {
                this.myValue = result;
            }
        }
        return result;
    }

    public boolean isCached() {
        return this.myValue != null;
    }

    public void drop() {
        this.myValue = null;
    }
}

