/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.KeyedExtensionCollector;
import com.intellij.util.containers.ContainerUtil;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassExtension<T>
extends KeyedExtensionCollector<T, Class> {
    public ClassExtension(@NotNull String epName) {
        super(epName);
    }

    @Override
    @NotNull
    protected String keyToString(@NotNull Class key) {
        return key.getName();
    }

    @Override
    @NotNull
    protected List<T> buildExtensions(@NotNull String key, @NotNull Class classKey) {
        LinkedHashSet<String> allSupers = new LinkedHashSet<String>();
        ClassExtension.collectSupers(classKey, allSupers);
        return this.buildExtensionsWithInheritance(allSupers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<T> buildExtensionsWithInheritance(Set<String> supers) {
        List extensions = this.getExtensions();
        String string2 = this.myLock;
        synchronized (string2) {
            List result = null;
            for (String aSuper : supers) {
                result = this.buildExtensionsFromExplicitRegistration(result, key -> aSuper.equals(key));
            }
            for (String aSuper : supers) {
                result = this.buildExtensionsFromExtensionPoint(result, bean -> aSuper.equals(bean.getKey()), extensions);
            }
            return ContainerUtil.notNullize(result);
        }
    }

    private static void collectSupers(@NotNull Class classKey, @NotNull Set<? super String> allSupers) {
        Class<?>[] interfaces;
        allSupers.add(classKey.getName());
        for (Class<?> anInterface : interfaces = classKey.getInterfaces()) {
            ClassExtension.collectSupers(anInterface, allSupers);
        }
        Class superClass = classKey.getSuperclass();
        if (superClass != null) {
            ClassExtension.collectSupers(superClass, allSupers);
        }
    }

    @Nullable
    public T forClass(@NotNull Class t) {
        List ts = this.forKey(t);
        return ts.isEmpty() ? null : (T)ts.get(0);
    }

    @Override
    protected void invalidateCacheForExtension(String key) {
        this.clearCache();
    }
}

