/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.BuildNumber;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildRange {
    private final BuildNumber since;
    private final BuildNumber until;

    public BuildRange(@NotNull BuildNumber since, @NotNull BuildNumber until) {
        this.since = since;
        this.until = until;
        if (since.compareTo(until) > 0) {
            throw new IllegalArgumentException("Invalid range: [" + since + "; " + until + "]");
        }
    }

    public boolean inRange(@NotNull BuildNumber build) {
        return this.since.compareTo(build) <= 0 && build.compareTo(this.until) <= 0;
    }

    @Contract(value="null, _ -> null; _, null -> null")
    public static BuildRange fromStrings(@Nullable String sinceVal, @Nullable String untilVal) {
        BuildNumber since = BuildNumber.fromString(sinceVal);
        BuildNumber until = BuildNumber.fromString(untilVal);
        return since != null && until != null ? new BuildRange(since, until) : null;
    }
}

