/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress;

import com.intellij.openapi.progress.Cancellation;
import java.util.concurrent.Callable;
import kotlinx.coroutines.CompletableDeferred;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class CancellationCallable<V>
implements Callable<V> {
    @NotNull
    private final CompletableDeferred<V> myDeferred;
    @NotNull
    private final Callable<? extends V> myCallable;

    public CancellationCallable(@NotNull CompletableDeferred<V> deferred, @NotNull Callable<? extends V> callable) {
        this.myDeferred = deferred;
        this.myCallable = callable;
    }

    @Override
    public V call() throws Exception {
        try {
            Object result = Cancellation.withJob(this.myDeferred, this.myCallable::call);
            this.myDeferred.complete(result);
            return (V)result;
        }
        catch (Throwable e) {
            this.myDeferred.completeExceptionally(e);
            throw e;
        }
    }
}

