/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.util.KeyedExtensionCollector;
import com.intellij.util.KeyedLazyInstance;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class FileTypeExtension<T>
extends KeyedExtensionCollector<T, FileType> {
    public FileTypeExtension(@NonNls String epName) {
        super(epName);
    }

    public FileTypeExtension(@NotNull ExtensionPointName<KeyedLazyInstance<T>> epName) {
        super(epName);
    }

    @Override
    @NotNull
    protected String keyToString(@NotNull FileType key) {
        return key.getName();
    }

    @NotNull
    public List<T> allForFileType(@NotNull FileType t) {
        return this.forKey(t);
    }

    public T forFileType(@NotNull FileType t) {
        List<T> all = this.allForFileType(t);
        return all.isEmpty() ? null : (T)all.get(0);
    }

    public Map<FileType, T> getAllRegisteredExtensions() {
        List extensions = this.getExtensions();
        HashMap result = new HashMap();
        for (KeyedLazyInstance extension : extensions) {
            FileType fileType = FileTypeRegistry.getInstance().findFileTypeByName(extension.getKey());
            if (fileType == null) continue;
            result.put(fileType, extension.getInstance());
        }
        return result;
    }
}

