/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.BaseExtensionPointName;
import com.intellij.openapi.extensions.DefaultPluginDescriptor;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointDescriptor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.extensions.impl.BeanExtensionPoint;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.extensions.impl.InterfaceExtensionPoint;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ThreeState;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public final class ExtensionsAreaImpl
implements ExtensionsArea {
    private static final Logger LOG = Logger.getInstance(ExtensionsAreaImpl.class);
    private static final boolean DEBUG_REGISTRATION = false;
    private final ComponentManager componentManager;
    public volatile Map<String, ExtensionPointImpl<?>> extensionPoints = Collections.emptyMap();
    private final Map<String, Throwable> epTraces = null;

    public ExtensionsAreaImpl(@NotNull ComponentManager componentManager) {
        this.componentManager = componentManager;
    }

    @TestOnly
    public void notifyAreaReplaced(@Nullable ExtensionsAreaImpl newArea) {
        HashSet<String> processedEPs = new HashSet<String>(this.extensionPoints.size());
        for (ExtensionPointImpl<?> point : this.extensionPoints.values()) {
            point.notifyAreaReplaced(this);
            processedEPs.add(point.getName());
        }
        if (newArea == null) {
            return;
        }
        for (ExtensionPointImpl<?> point : newArea.extensionPoints.values()) {
            if (processedEPs.contains(point.getName())) continue;
            point.notifyAreaReplaced(this);
        }
    }

    @TestOnly
    public void registerExtensionPoints(@NotNull PluginDescriptor pluginDescriptor, @NotNull List<? extends Element> extensionPointElements) {
        for (Element element : extensionPointElements) {
            String pointName = element.getAttributeValue("qualifiedName");
            if (pointName == null) {
                String name = element.getAttributeValue("name");
                if (name == null) {
                    throw this.componentManager.createError("'name' attribute not specified for extension point in '" + pluginDescriptor + "' plugin", pluginDescriptor.getPluginId());
                }
                pointName = pluginDescriptor.getPluginId().getIdString() + '.' + name;
            }
            String beanClassName = element.getAttributeValue("beanClass");
            String interfaceClassName = element.getAttributeValue("interface");
            if (beanClassName == null && interfaceClassName == null) {
                throw this.componentManager.createError("Neither 'beanClass' nor 'interface' attribute is specified for extension point '" + pointName + "' in '" + pluginDescriptor + "' plugin", pluginDescriptor.getPluginId());
            }
            if (beanClassName != null && interfaceClassName != null) {
                throw this.componentManager.createError("Both 'beanClass' and 'interface' attributes are specified for extension point '" + pointName + "' in '" + pluginDescriptor + "' plugin", pluginDescriptor.getPluginId());
            }
            boolean dynamic = Boolean.parseBoolean(element.getAttributeValue("dynamic"));
            String className = interfaceClassName == null ? beanClassName : interfaceClassName;
            this.doRegisterExtensionPoint(pointName, className, pluginDescriptor, interfaceClassName != null, dynamic);
        }
    }

    public boolean unregisterExtensions(@NotNull String extensionPointName, @NotNull PluginDescriptor pluginDescriptor, @NotNull List<? super Runnable> priorityListenerCallbacks, @NotNull List<? super Runnable> listenerCallbacks) {
        ExtensionPoint point = this.getExtensionPointIfRegistered(extensionPointName);
        if (point == null) {
            return false;
        }
        ((ExtensionPointImpl)point).unregisterExtensions(this.componentManager, pluginDescriptor, priorityListenerCallbacks, listenerCallbacks);
        return true;
    }

    public void resetExtensionPoints(@NotNull List<ExtensionPointDescriptor> descriptors, @NotNull PluginDescriptor pluginDescriptor) {
        for (ExtensionPointDescriptor descriptor : descriptors) {
            ExtensionPoint extensionPoint = this.getExtensionPointIfRegistered(descriptor.getQualifiedName(pluginDescriptor));
            if (extensionPoint == null) continue;
            ((ExtensionPointImpl)extensionPoint).reset();
        }
    }

    public void clearUserCache() {
        this.extensionPoints.values().forEach(ExtensionPointImpl::clearUserCache);
    }

    public void unregisterExtensionPoints(@NotNull List<ExtensionPointDescriptor> descriptors, @NotNull PluginDescriptor pluginDescriptor) {
        if (descriptors.isEmpty()) {
            return;
        }
        HashMap map = new HashMap(this.extensionPoints);
        for (ExtensionPointDescriptor descriptor : descriptors) {
            map.remove(descriptor.getQualifiedName(pluginDescriptor));
        }
        this.extensionPoints = map;
    }

    @TestOnly
    public void registerExtensionPoint(@NotNull BaseExtensionPointName<?> extensionPoint, @NotNull String extensionPointBeanClass, @NotNull ExtensionPoint.Kind kind, @NotNull Disposable parentDisposable) {
        String extensionPointName = extensionPoint.getName();
        this.registerExtensionPoint(extensionPointName, extensionPointBeanClass, kind, false);
        Disposer.register(parentDisposable, () -> this.unregisterExtensionPoint(extensionPointName));
    }

    @Override
    @TestOnly
    public void registerExtensionPoint(@NotNull String extensionPointName, @NotNull String extensionPointBeanClass, @NotNull ExtensionPoint.Kind kind, boolean dynamic) {
        DefaultPluginDescriptor pluginDescriptor = new DefaultPluginDescriptor(PluginId.getId("fakeIdForTests"));
        this.doRegisterExtensionPoint(extensionPointName, extensionPointBeanClass, pluginDescriptor, kind == ExtensionPoint.Kind.INTERFACE, dynamic);
    }

    @TestOnly
    @NotNull
    public <T> ExtensionPointImpl<T> registerPoint(@NotNull String name, @NotNull Class<T> extensionClass, @NotNull PluginDescriptor pluginDescriptor, boolean isDynamic) {
        return this.doRegisterExtensionPoint(name, extensionClass.getName(), pluginDescriptor, extensionClass.isInterface() || (extensionClass.getModifiers() & 0x400) != 0, isDynamic);
    }

    @TestOnly
    @NotNull
    private <T> ExtensionPointImpl<T> doRegisterExtensionPoint(@NotNull String name, @NotNull String extensionClass, @NotNull PluginDescriptor pluginDescriptor, boolean isInterface, boolean dynamic) {
        ExtensionPointImpl point = isInterface ? new InterfaceExtensionPoint(name, extensionClass, pluginDescriptor, this.componentManager, null, dynamic) : new BeanExtensionPoint(name, extensionClass, pluginDescriptor, this.componentManager, dynamic);
        this.checkThatPointNotDuplicated(name, point.getPluginDescriptor());
        HashMap<String, ExtensionPointImpl> newMap = new HashMap<String, ExtensionPointImpl>(this.extensionPoints.size() + 1);
        newMap.putAll(this.extensionPoints);
        newMap.put(name, point);
        this.extensionPoints = Collections.unmodifiableMap(newMap);
        return point;
    }

    @TestOnly
    @NotNull
    public <T> ExtensionPointImpl<T> registerFakeBeanPoint(@NotNull String name, @NotNull PluginDescriptor pluginDescriptor) {
        return this.doRegisterExtensionPoint(name, Object.class.getName(), pluginDescriptor, false, false);
    }

    private void checkThatPointNotDuplicated(@NotNull String pointName, @NotNull PluginDescriptor pluginDescriptor) {
        if (!this.hasExtensionPoint(pointName)) {
            return;
        }
        PluginId id1 = ((ExtensionPointImpl)this.getExtensionPoint(pointName)).getPluginDescriptor().getPluginId();
        PluginId id2 = pluginDescriptor.getPluginId();
        @NonNls String message = "Duplicate registration for EP '" + pointName + "': first in " + id1 + ", second in " + id2;
        throw this.componentManager.createError(message, pluginDescriptor.getPluginId());
    }

    public void registerExtensionPoints(@NotNull List<ExtensionPointDescriptor> points, @NotNull PluginDescriptor pluginDescriptor) {
        HashMap map = new HashMap(this.extensionPoints);
        ExtensionsAreaImpl.createExtensionPoints(points, this.componentManager, map, pluginDescriptor);
        this.extensionPoints = map;
    }

    public void setPoints(@NotNull Map<String, ExtensionPointImpl<?>> value) {
        this.extensionPoints = value;
    }

    @ApiStatus.Internal
    public static void createExtensionPoints(@NotNull List<ExtensionPointDescriptor> points, @NotNull ComponentManager componentManager, @NotNull Map<? super String, ExtensionPointImpl<?>> result, @NotNull PluginDescriptor pluginDescriptor) {
        for (ExtensionPointDescriptor descriptor : points) {
            ExtensionPointImpl point;
            String name = descriptor.getQualifiedName(pluginDescriptor);
            ExtensionPointImpl old = result.putIfAbsent(name, point = descriptor.isBean ? new BeanExtensionPoint(name, descriptor.className, pluginDescriptor, componentManager, descriptor.isDynamic) : new InterfaceExtensionPoint(name, descriptor.className, pluginDescriptor, componentManager, null, descriptor.isDynamic));
            if (old == null) continue;
            PluginDescriptor oldPluginDescriptor = old.getPluginDescriptor();
            throw componentManager.createError("Duplicate registration for EP " + name + ": first in " + oldPluginDescriptor + ", second in " + pluginDescriptor, pluginDescriptor.getPluginId());
        }
    }

    @NotNull
    public <T> ExtensionPointImpl<T> getExtensionPoint(@NotNull String extensionPointName) {
        ExtensionPoint extensionPoint = this.getExtensionPointIfRegistered(extensionPointName);
        if (extensionPoint == null) {
            throw new IllegalArgumentException("Missing extension point: " + extensionPointName + " in container " + this.componentManager);
        }
        return extensionPoint;
    }

    public <T> ExtensionPointImpl<T> getExtensionPointIfRegistered(@NotNull String extensionPointName) {
        return this.extensionPoints.get(extensionPointName);
    }

    @Override
    @NotNull
    public <T> ExtensionPoint<T> getExtensionPoint(@NotNull ExtensionPointName<T> extensionPointName) {
        return this.getExtensionPoint(extensionPointName.getName());
    }

    @TestOnly
    public void processExtensionPoints(@NotNull Consumer<? super ExtensionPointImpl<?>> consumer) {
        this.extensionPoints.values().forEach(consumer);
    }

    @ApiStatus.Internal
    @Nullable
    public <T> T findExtensionByClass(@NotNull Class<T> aClass) {
        if (aClass.getName().equals("com.intellij.execution.executors.DefaultDebugExecutor")) {
            return ((ExtensionPointImpl)this.getExtensionPointIfRegistered("com.intellij.executor")).findExtension(aClass, false, ThreeState.YES);
        }
        for (ExtensionPointImpl<?> point : this.extensionPoints.values()) {
            if (!(point instanceof InterfaceExtensionPoint)) continue;
            try {
                T extension;
                Class<T> extensionClass = point.getExtensionClass();
                if (!extensionClass.isAssignableFrom(aClass) || (extension = point.findExtension(aClass, false, ThreeState.YES)) == null) continue;
                return extension;
            }
            catch (Throwable e) {
                LOG.warn("error during findExtensionPointByClass", e);
            }
        }
        return null;
    }

    @Override
    @TestOnly
    public void unregisterExtensionPoint(@NotNull String extensionPointName) {
        ExtensionPoint extensionPoint = this.getExtensionPointIfRegistered(extensionPointName);
        if (extensionPoint != null) {
            ((ExtensionPointImpl)extensionPoint).reset();
            HashMap map = new HashMap(this.extensionPoints);
            map.remove(extensionPointName);
            this.extensionPoints = Collections.unmodifiableMap(map);
        }
    }

    @Override
    public boolean hasExtensionPoint(@NotNull String extensionPointName) {
        return this.extensionPoints.containsKey(extensionPointName);
    }

    @Override
    public boolean hasExtensionPoint(@NotNull ExtensionPointName<?> extensionPointName) {
        return this.hasExtensionPoint(extensionPointName.getName());
    }

    public String toString() {
        return this.componentManager.toString();
    }
}

