/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.BaseExtensionPointName;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.impl.ExtensionProcessingHelper;
import com.intellij.util.ThreeState;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProjectExtensionPointName<T>
extends BaseExtensionPointName<T> {
    public ProjectExtensionPointName(@NotNull @NonNls String name) {
        super(name);
    }

    @NotNull
    public ExtensionPoint<T> getPoint(@NotNull AreaInstance areaInstance) {
        return this.getPointImpl(areaInstance);
    }

    @NotNull
    public List<T> getExtensions(@NotNull AreaInstance areaInstance) {
        return this.getPointImpl(areaInstance).getExtensionList();
    }

    @NotNull
    public Stream<T> extensions(@NotNull AreaInstance areaInstance) {
        return this.getPointImpl(areaInstance).extensions();
    }

    @Nullable
    public <V extends T> V findExtension(@NotNull Class<V> instanceOf, @NotNull AreaInstance areaInstance) {
        return this.getPointImpl(areaInstance).findExtension(instanceOf, false, ThreeState.UNSURE);
    }

    @NotNull
    public <V extends T> V findExtensionOrFail(@NotNull Class<V> instanceOf, @NotNull AreaInstance areaInstance) {
        return this.getPointImpl(areaInstance).findExtension(instanceOf, true, ThreeState.UNSURE);
    }

    public boolean hasAnyExtensions(@NotNull AreaInstance areaInstance) {
        return this.getPointImpl(areaInstance).size() != 0;
    }

    @Nullable
    public T findFirstSafe(@NotNull AreaInstance areaInstance, @NotNull Predicate<? super T> predicate) {
        return ExtensionProcessingHelper.findFirstSafe(predicate, this.getPointImpl(areaInstance));
    }

    @Nullable
    public <R> R computeSafeIfAny(@NotNull AreaInstance areaInstance, @NotNull Function<? super T, ? extends R> processor) {
        return ExtensionProcessingHelper.computeSafeIfAny(processor, this.getPointImpl(areaInstance));
    }

    public void addExtensionPointListener(@NotNull AreaInstance areaInstance, @NotNull ExtensionPointListener<T> listener, @Nullable Disposable parentDisposable) {
        this.getPointImpl(areaInstance).addExtensionPointListener(listener, false, parentDisposable);
    }

    public void addChangeListener(@NotNull AreaInstance areaInstance, @NotNull Runnable listener, @Nullable Disposable parentDisposable) {
        this.getPointImpl(areaInstance).addChangeListener(listener, parentDisposable);
    }

    public void processWithPluginDescriptor(@NotNull AreaInstance areaInstance, @NotNull BiConsumer<? super T, ? super PluginDescriptor> consumer) {
        this.getPointImpl(areaInstance).processWithPluginDescriptor(true, consumer);
    }

    @ApiStatus.Experimental
    @NotNull
    public Iterable<T> getIterable(@NotNull AreaInstance areaInstance) {
        return this.getPointImpl(areaInstance);
    }
}

