/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PluginId
implements Comparable<PluginId> {
    public static final PluginId[] EMPTY_ARRAY = new PluginId[0];
    private static final Map<String, PluginId> registeredIds = new ConcurrentHashMap<String, PluginId>();
    @NotNull
    private final String idString;

    @NotNull
    public static PluginId getId(@NotNull String idString) {
        return registeredIds.computeIfAbsent(idString, PluginId::new);
    }

    @Nullable
    public static PluginId findId(@NotNull String idString) {
        return registeredIds.get(idString);
    }

    @Nullable
    public static PluginId findId(String ... idStrings) {
        for (String idString : idStrings) {
            PluginId pluginId = registeredIds.get(idString);
            if (pluginId == null) continue;
            return pluginId;
        }
        return null;
    }

    @NotNull
    public static Set<PluginId> getRegisteredIds() {
        return Collections.unmodifiableSet(new HashSet<PluginId>(registeredIds.values()));
    }

    private PluginId(@NotNull String idString) {
        this.idString = idString;
    }

    @NotNull
    public String getIdString() {
        return this.idString;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PluginId)) {
            return false;
        }
        PluginId pluginId = (PluginId)o;
        return this.idString.equals(pluginId.idString);
    }

    public int hashCode() {
        return this.idString.hashCode();
    }

    @Override
    public int compareTo(@NotNull PluginId o) {
        return this.idString.compareTo(o.idString);
    }

    public String toString() {
        return this.idString;
    }
}

