/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.BaseExtensionPointName;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.impl.ExtensionProcessingHelper;
import com.intellij.util.ThreeState;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExtensionPointName<T>
extends BaseExtensionPointName<T> {
    public ExtensionPointName(@NotNull @NonNls String name) {
        super(name);
    }

    @NotNull
    public static <T> ExtensionPointName<T> create(@NonNls @NotNull String name) {
        return new ExtensionPointName<T>(name);
    }

    public T @NotNull [] getExtensions() {
        return this.getPointImpl(null).getExtensions();
    }

    @NotNull
    public List<T> getExtensionList() {
        return this.getPointImpl(null).getExtensionList();
    }

    public void forEachExtensionSafe(@NotNull Consumer<? super T> consumer) {
        ExtensionProcessingHelper.forEachExtensionSafe(this.getPointImpl(null), consumer);
    }

    @Nullable
    public T findFirstSafe(@NotNull Predicate<? super T> predicate) {
        return ExtensionProcessingHelper.findFirstSafe(predicate, this.getPointImpl(null));
    }

    @Nullable
    public <R> R computeSafeIfAny(@NotNull Function<? super T, ? extends R> processor) {
        return ExtensionProcessingHelper.computeSafeIfAny(processor, this.getPointImpl(null));
    }

    @NotNull
    public List<T> getExtensionsIfPointIsRegistered() {
        return this.getExtensionsIfPointIsRegistered(null);
    }

    @NotNull
    public List<T> getExtensionsIfPointIsRegistered(@Nullable AreaInstance areaInstance) {
        ExtensionsArea area = areaInstance == null ? Extensions.getRootArea() : areaInstance.getExtensionArea();
        ExtensionPoint point = area == null ? null : area.getExtensionPointIfRegistered(this.getName());
        return point == null ? Collections.emptyList() : point.getExtensionList();
    }

    @NotNull
    public Stream<T> extensions() {
        return this.getPointImpl(null).extensions();
    }

    public boolean hasAnyExtensions() {
        return this.getPointImpl(null).size() != 0;
    }

    @NotNull
    public List<T> getExtensionList(@Nullable AreaInstance areaInstance) {
        return this.getPointImpl(areaInstance).getExtensionList();
    }

    public T @NotNull [] getExtensions(@Nullable AreaInstance areaInstance) {
        return this.getPointImpl(areaInstance).getExtensions();
    }

    @NotNull
    public Stream<T> extensions(@Nullable AreaInstance areaInstance) {
        return this.getPointImpl(areaInstance).extensions();
    }

    @Deprecated
    @NotNull
    public ExtensionPoint<T> getPoint(@Nullable AreaInstance areaInstance) {
        return this.getPointImpl(areaInstance);
    }

    @NotNull
    public ExtensionPoint<T> getPoint() {
        return this.getPointImpl(null);
    }

    @Nullable
    public <V extends T> V findExtension(@NotNull Class<V> instanceOf) {
        return this.getPointImpl(null).findExtension(instanceOf, false, ThreeState.UNSURE);
    }

    @NotNull
    public <V extends T> V findExtensionOrFail(@NotNull Class<V> exactClass) {
        return this.getPointImpl(null).findExtension(exactClass, true, ThreeState.UNSURE);
    }

    @Nullable
    public <V extends T> V findFirstAssignableExtension(@NotNull Class<V> instanceOf) {
        return this.getPointImpl(null).findExtension(instanceOf, true, ThreeState.NO);
    }

    @ApiStatus.Internal
    @NotNull
    public Iterable<T> getIterable() {
        return this.getPointImpl(null);
    }

    @ApiStatus.Internal
    public void processWithPluginDescriptor(@NotNull BiConsumer<? super T, ? super PluginDescriptor> consumer) {
        this.getPointImpl(null).processWithPluginDescriptor(true, consumer);
    }

    public void addExtensionPointListener(@NotNull ExtensionPointListener<T> listener, @Nullable Disposable parentDisposable) {
        this.getPointImpl(null).addExtensionPointListener(listener, false, parentDisposable);
    }

    public void addChangeListener(@NotNull Runnable listener, @Nullable Disposable parentDisposable) {
        this.getPointImpl(null).addChangeListener(listener, parentDisposable);
    }

    @ApiStatus.Experimental
    @NotNull
    public <K> List<T> getByGroupingKey(@NotNull K key, @NotNull Class<?> cacheId, @NotNull @NotNull Function<? super @NotNull T, ? extends @Nullable K> keyMapper) {
        return ExtensionProcessingHelper.getByGroupingKey(this.getPointImpl(null), cacheId, key, keyMapper);
    }

    @ApiStatus.Experimental
    @Nullable
    public <K> T getByKey(@NotNull K key, @NotNull Class<?> cacheId, @NotNull @NotNull Function<? super @NotNull T, ? extends @Nullable K> keyMapper) {
        return ExtensionProcessingHelper.getByKey(this.getPointImpl(null), key, cacheId, keyMapper);
    }

    @ApiStatus.Experimental
    @Nullable
    public <K, V> V getByKey(@NotNull K key, @NotNull Class<?> cacheId, @NotNull @NotNull Function<? super @NotNull T, ? extends @Nullable K> keyMapper, @NotNull @NotNull Function<? super @NotNull T, ? extends @Nullable V> valueMapper) {
        return ExtensionProcessingHelper.getByKey(this.getPointImpl(null), key, cacheId, keyMapper, valueMapper);
    }

    @ApiStatus.Experimental
    @NotNull
    public <K, V> V computeIfAbsent(@NotNull K key, @NotNull Class<?> cacheId, @NotNull @NotNull Function<? super @NotNull K, ? extends @NotNull V> valueMapper) {
        return ExtensionProcessingHelper.computeIfAbsent(this.getPointImpl(null), key, cacheId, valueMapper);
    }

    @ApiStatus.Experimental
    @NotNull
    public <V> V computeIfAbsent(@NotNull Class<?> cacheId, @NotNull @NotNull Supplier<? extends @NotNull V> valueMapper) {
        return ExtensionProcessingHelper.computeIfAbsent(this.getPointImpl(null), cacheId, valueMapper);
    }
}

