/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.markup;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.markup.AttributesFlyweight;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributesEffectsBuilder;
import java.awt.Color;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.intellij.lang.annotations.JdkConstants;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextAttributes
implements Cloneable {
    private static final Logger LOG = Logger.getInstance(TextAttributes.class);
    private static final AttributesFlyweight DEFAULT_FLYWEIGHT = AttributesFlyweight.create(null, null, 0, null, EffectType.BOXED, Collections.emptyMap(), null);
    public static final TextAttributes ERASE_MARKER = new TextAttributes();
    @NotNull
    private AttributesFlyweight myAttrs;

    @Contract(value="!null, !null -> !null")
    public static TextAttributes merge(@Nullable TextAttributes under, @Nullable TextAttributes above) {
        if (under == null) {
            return above;
        }
        if (above == null) {
            return under;
        }
        TextAttributes attrs = under.clone();
        if (above.getBackgroundColor() != null) {
            attrs.setBackgroundColor(above.getBackgroundColor());
        }
        if (above.getForegroundColor() != null) {
            attrs.setForegroundColor(above.getForegroundColor());
        }
        attrs.setFontType(above.getFontType() | under.getFontType());
        TextAttributesEffectsBuilder.create(under).coverWith(above).applyTo(attrs);
        return attrs;
    }

    public TextAttributes() {
        this(DEFAULT_FLYWEIGHT);
    }

    private TextAttributes(@NotNull AttributesFlyweight attributesFlyweight) {
        this.myAttrs = attributesFlyweight;
    }

    public TextAttributes(@NotNull Element element) {
        this.readExternal(element);
    }

    public TextAttributes(@Nullable Color foregroundColor, @Nullable Color backgroundColor, @Nullable Color effectColor, EffectType effectType, @JdkConstants.FontStyle int fontType) {
        this.setAttributes(foregroundColor, backgroundColor, effectColor, null, effectType, fontType);
    }

    public void copyFrom(@NotNull TextAttributes other) {
        this.myAttrs = other.myAttrs;
    }

    public void setAttributes(Color foregroundColor, Color backgroundColor, Color effectColor, Color errorStripeColor, EffectType effectType, @JdkConstants.FontStyle int fontType) {
        this.myAttrs = AttributesFlyweight.create(foregroundColor, backgroundColor, fontType, effectColor, effectType, Collections.emptyMap(), errorStripeColor);
    }

    public boolean isEmpty() {
        return this.getForegroundColor() == null && this.getBackgroundColor() == null && this.getEffectColor() == null && this.getFontType() == 0;
    }

    @NotNull
    public AttributesFlyweight getFlyweight() {
        return this.myAttrs;
    }

    @NotNull
    public static TextAttributes fromFlyweight(@NotNull AttributesFlyweight flyweight) {
        return new TextAttributes(flyweight);
    }

    public Color getForegroundColor() {
        return this.myAttrs.getForeground();
    }

    public void setForegroundColor(Color color) {
        this.myAttrs = this.myAttrs.withForeground(color);
    }

    public Color getBackgroundColor() {
        return this.myAttrs.getBackground();
    }

    public void setBackgroundColor(Color color) {
        this.myAttrs = this.myAttrs.withBackground(color);
    }

    public Color getEffectColor() {
        return this.myAttrs.getEffectColor();
    }

    public void setEffectColor(Color color) {
        this.myAttrs = this.myAttrs.withEffectColor(color);
    }

    public Color getErrorStripeColor() {
        return this.myAttrs.getErrorStripeColor();
    }

    public void setErrorStripeColor(Color color) {
        this.myAttrs = this.myAttrs.withErrorStripeColor(color);
    }

    @ApiStatus.Experimental
    public boolean hasEffects() {
        return this.myAttrs.hasEffects();
    }

    @ApiStatus.Experimental
    public void setAdditionalEffects(@NotNull @NotNull Map<@NotNull EffectType, ? extends @NotNull Color> effectsMap) {
        this.myAttrs = this.myAttrs.withAdditionalEffects(effectsMap);
    }

    @ApiStatus.Experimental
    public void withAdditionalEffect(@NotNull EffectType effectType, @NotNull Color color) {
        TextAttributesEffectsBuilder.create(this).coverWith(effectType, color).applyTo(this);
    }

    @Nullable
    public EffectType getEffectType() {
        return this.myAttrs.getEffectType();
    }

    @ApiStatus.Experimental
    public void forEachAdditionalEffect(@NotNull BiConsumer<? super EffectType, ? super Color> consumer) {
        this.myAttrs.getAdditionalEffects().forEach(consumer);
    }

    @ApiStatus.Experimental
    public void forEachEffect(@NotNull BiConsumer<? super EffectType, ? super Color> consumer) {
        this.myAttrs.getAllEffects().forEach(consumer);
    }

    public void setEffectType(EffectType effectType) {
        this.myAttrs = this.myAttrs.withEffectType(effectType);
    }

    @JdkConstants.FontStyle
    public int getFontType() {
        return this.myAttrs.getFontType();
    }

    public void setFontType(@JdkConstants.FontStyle int type) {
        if (type < 0 || type > 3) {
            LOG.error("Wrong font type: " + type);
            type = 0;
        }
        this.myAttrs = this.myAttrs.withFontType(type);
    }

    public TextAttributes clone() {
        return new TextAttributes(this.myAttrs);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TextAttributes)) {
            return false;
        }
        return Objects.equals(this.myAttrs, ((TextAttributes)obj).myAttrs);
    }

    public int hashCode() {
        return this.myAttrs.hashCode();
    }

    public void readExternal(@NotNull Element element) {
        this.myAttrs = AttributesFlyweight.create(element);
    }

    public void writeExternal(Element element) {
        this.myAttrs.writeExternal(element);
    }

    public String toString() {
        return "[" + this.getForegroundColor() + "," + this.getBackgroundColor() + "," + this.getFontType() + "," + (Object)((Object)this.getEffectType()) + "," + this.getEffectColor() + "," + this.myAttrs.getAdditionalEffects() + "," + this.getErrorStripeColor() + "]";
    }
}

