/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diagnostic;

import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.DefaultLogger;
import com.intellij.openapi.diagnostic.LogLevel;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.function.Function;
import org.apache.log4j.Level;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public abstract class Logger {
    private static boolean isUnitTestMode;
    private static Factory ourFactory;
    static final Function<Attachment, String> ATTACHMENT_TO_STRING;

    public static void setFactory(@NotNull Class<? extends Factory> factory) {
        if (Logger.isInitialized()) {
            if (factory.isInstance(ourFactory)) {
                return;
            }
            Logger.logFactoryChanged(factory);
        }
        try {
            Constructor<? extends Factory> constructor = factory.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            ourFactory = constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static void setFactory(@NotNull Factory factory) {
        if (Logger.isInitialized()) {
            Logger.logFactoryChanged(factory.getClass());
        }
        ourFactory = factory;
    }

    private static void logFactoryChanged(Class<? extends Factory> factory) {
        System.out.println("Changing log factory from " + ourFactory.getClass().getCanonicalName() + " to " + factory.getCanonicalName() + '\n' + ExceptionUtil.getThrowableText(new Throwable()));
    }

    public static Factory getFactory() {
        return ourFactory;
    }

    public static boolean isInitialized() {
        return !(ourFactory instanceof DefaultFactory);
    }

    @NotNull
    public static Logger getInstance(@NotNull String category) {
        return ourFactory.getLoggerInstance(category);
    }

    @NotNull
    public static Logger getInstance(@NotNull Class<?> cl) {
        return ourFactory.getLoggerInstance("#" + cl.getName());
    }

    public abstract boolean isDebugEnabled();

    public abstract void debug(String var1);

    public abstract void debug(@Nullable Throwable var1);

    public abstract void debug(String var1, @Nullable Throwable var2);

    public void debug(@NotNull String message, Object ... details) {
        if (this.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(message);
            for (Object detail : details) {
                sb.append(detail);
            }
            this.debug(sb.toString());
        }
    }

    public void debugValues(@NotNull String header, @NotNull Collection<?> values) {
        if (this.isDebugEnabled()) {
            StringBuilder text = new StringBuilder();
            text.append(header).append(" (").append(values.size()).append(")");
            if (!values.isEmpty()) {
                text.append(":");
                for (Object value : values) {
                    text.append("\n");
                    text.append(value);
                }
            }
            this.debug(text.toString());
        }
    }

    public final void infoWithDebug(@NotNull Throwable t) {
        this.infoWithDebug(t.toString(), t);
    }

    public final void infoWithDebug(@NotNull String message, @NotNull Throwable t) {
        this.info(message);
        this.debug(t);
    }

    public final void warnWithDebug(@NotNull Throwable t) {
        this.warnWithDebug(t.toString(), t);
    }

    public final void warnWithDebug(@NotNull String message, @NotNull Throwable t) {
        this.warn(message);
        this.debug(t);
    }

    public boolean isTraceEnabled() {
        return this.isDebugEnabled();
    }

    public void trace(String message) {
        this.debug(message);
    }

    public void trace(@Nullable Throwable t) {
        this.debug(t);
    }

    public void info(@NotNull Throwable t) {
        this.info(t.getMessage(), t);
    }

    public abstract void info(String var1);

    public abstract void info(String var1, @Nullable Throwable var2);

    public void warn(String message) {
        this.warn(message, null);
    }

    public void warn(@NotNull Throwable t) {
        this.warn(t.getMessage(), t);
    }

    public abstract void warn(String var1, @Nullable Throwable var2);

    public void error(String message) {
        this.error(message, new Throwable(message), ArrayUtilRt.EMPTY_STRING_ARRAY);
    }

    public void error(Object message) {
        this.error(String.valueOf(message));
    }

    public void error(String message, Attachment ... attachments) {
        this.error(message, (Throwable)null, attachments);
    }

    public void error(String message, @Nullable Throwable t, Attachment ... attachments) {
        this.error(message, t, ContainerUtil.map2Array(attachments, String.class, ATTACHMENT_TO_STRING::apply));
    }

    public void error(String message, String ... details) {
        this.error(message, new Throwable(message), details);
    }

    public void error(String message, @Nullable Throwable t) {
        this.error(message, t, ArrayUtilRt.EMPTY_STRING_ARRAY);
    }

    public void error(@NotNull Throwable t) {
        this.error(t.getMessage(), t, ArrayUtilRt.EMPTY_STRING_ARRAY);
    }

    public abstract void error(String var1, @Nullable Throwable var2, String ... var3);

    @Contract(value="false,_->fail")
    public boolean assertTrue(boolean value, @Nullable Object message) {
        if (!value) {
            String resultMessage = "Assertion failed";
            if (message != null) {
                resultMessage = resultMessage + ": " + message;
            }
            this.error(resultMessage, new Throwable(resultMessage));
        }
        return value;
    }

    @Contract(value="false->fail")
    public boolean assertTrue(boolean value) {
        return value || this.assertTrue(false, null);
    }

    @Deprecated
    public abstract void setLevel(@NotNull Level var1);

    public void setLevel(@NotNull LogLevel level) {
        switch (level) {
            case OFF: {
                this.setLevel(Level.OFF);
                break;
            }
            case ERROR: {
                this.setLevel(Level.ERROR);
                break;
            }
            case WARNING: {
                this.setLevel(Level.WARN);
                break;
            }
            case INFO: {
                this.setLevel(Level.INFO);
                break;
            }
            case DEBUG: {
                this.setLevel(Level.DEBUG);
                break;
            }
            case TRACE: {
                this.setLevel(Level.TRACE);
                break;
            }
            case ALL: {
                this.setLevel(Level.ALL);
            }
        }
    }

    protected static Throwable ensureNotControlFlow(@Nullable Throwable t) {
        return t instanceof ControlFlowException ? new Throwable("Control-flow exceptions (like " + t.getClass().getSimpleName() + ") should never be logged: ignore for explicitly started processes or rethrow to handle on the outer process level", t) : t;
    }

    @TestOnly
    public static void setUnitTestMode() {
        isUnitTestMode = true;
    }

    public void warnInProduction(@NotNull Throwable t) {
        if (isUnitTestMode) {
            this.error(t);
        } else {
            this.warn(t);
        }
    }

    static {
        ourFactory = new DefaultFactory();
        ATTACHMENT_TO_STRING = attachment -> attachment.getPath() + "\n" + attachment.getDisplayText();
    }

    private static final class DefaultFactory
    implements Factory {
        private DefaultFactory() {
        }

        @Override
        @NotNull
        public Logger getLoggerInstance(@NotNull String category) {
            return new DefaultLogger(category);
        }
    }

    public static interface Factory {
        @NotNull
        public Logger getLoggerInstance(@NotNull String var1);
    }
}

