/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diagnostic;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.ExceptionWithAttachments;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ExceptionUtil;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.log4j.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultLogger
extends Logger {
    private static boolean ourMirrorToStderr = true;

    public DefaultLogger(String category) {
    }

    @Override
    public boolean isDebugEnabled() {
        return false;
    }

    @Override
    public void debug(String message) {
    }

    @Override
    public void debug(Throwable t) {
    }

    @Override
    public void debug(String message, Throwable t) {
    }

    @Override
    public void info(String message) {
    }

    @Override
    public void info(String message, Throwable t) {
    }

    @Override
    public void warn(String message, @Nullable Throwable t) {
        t = DefaultLogger.ensureNotControlFlow(t);
        System.err.println("WARN: " + message);
        if (t != null) {
            t.printStackTrace(System.err);
        }
    }

    @Override
    public void error(String message, @Nullable Throwable t, String ... details) {
        t = DefaultLogger.ensureNotControlFlow(t);
        message = message + DefaultLogger.attachmentsToString(t);
        DefaultLogger.dumpExceptionsToStderr(message, t, details);
        throw new AssertionError(message, t);
    }

    public static void dumpExceptionsToStderr(String message, @Nullable Throwable t, String ... details) {
        if (DefaultLogger.shouldDumpExceptionToStderr()) {
            System.err.println("ERROR: " + message);
            if (t != null) {
                t.printStackTrace(System.err);
            }
            if (details.length > 0) {
                System.err.println("details: ");
                for (String detail : details) {
                    System.err.println(detail);
                }
            }
        }
    }

    @Override
    public void setLevel(@NotNull Level level) {
    }

    @NotNull
    public static String attachmentsToString(@Nullable Throwable t) {
        if (t != null) {
            String prefix = "\n\nAttachments:\n";
            String attachments = ExceptionUtil.findCauseAndSuppressed(t, ExceptionWithAttachments.class).stream().flatMap(e -> Stream.of(e.getAttachments())).map(ATTACHMENT_TO_STRING).collect(Collectors.joining("\n----\n", prefix, ""));
            if (!attachments.equals(prefix)) {
                return attachments;
            }
        }
        return "";
    }

    public static boolean shouldDumpExceptionToStderr() {
        return ourMirrorToStderr;
    }

    public static void disableStderrDumping(@NotNull Disposable parentDisposable) {
        boolean prev = ourMirrorToStderr;
        ourMirrorToStderr = false;
        Disposer.register(parentDisposable, () -> {
            ourMirrorToStderr = prev;
        });
    }
}

