/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diagnostic;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.PathUtilRt;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Base64;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Attachment {
    private static final Logger LOG = Logger.getInstance(Attachment.class);
    public static final Attachment[] EMPTY_ARRAY = new Attachment[0];
    private final String myPath;
    private final String myDisplayText;
    private final byte @Nullable [] myBytes;
    @Nullable
    private final Path myTemporaryFile;
    private boolean myIncluded;

    public Attachment(@NotNull String name, @NotNull Throwable throwable) {
        this(name + ".trace", ExceptionUtil.getThrowableText(throwable));
        this.myIncluded = true;
    }

    public Attachment(@NotNull String path, @NotNull String content) {
        this(path, content, null, null);
    }

    public Attachment(@NotNull String path, byte @NotNull [] bytes, @NotNull String displayText) {
        this(path, displayText, bytes, null);
    }

    public Attachment(@NotNull String path, @NotNull Path temporaryFile, @NotNull String displayText) {
        this(path, displayText, null, temporaryFile);
    }

    public Attachment(@NotNull String path, @NotNull File temporaryFile, @NotNull String displayText) {
        this(path, displayText, null, temporaryFile.toPath());
    }

    private Attachment(String path, String displayText, byte @Nullable [] bytes, @Nullable Path temporaryFile) {
        this.myPath = path;
        this.myDisplayText = displayText;
        this.myBytes = bytes;
        this.myTemporaryFile = temporaryFile;
    }

    @NotNull
    public String getDisplayText() {
        return this.myDisplayText;
    }

    @NotNull
    @NlsSafe
    public String getPath() {
        return this.myPath;
    }

    @NotNull
    @NlsSafe
    public String getName() {
        return PathUtilRt.getFileName((String)this.myPath);
    }

    @NotNull
    public String getEncodedBytes() {
        return Base64.getEncoder().encodeToString(this.getBytes());
    }

    public byte @NotNull [] getBytes() {
        if (this.myBytes != null) {
            return this.myBytes;
        }
        if (this.myTemporaryFile != null) {
            try {
                return Files.readAllBytes(this.myTemporaryFile);
            }
            catch (IOException e) {
                LOG.error("Failed to read attachment content from temp. file " + this.myTemporaryFile, e);
            }
        }
        if (this.myDisplayText != null) {
            return this.myDisplayText.getBytes(StandardCharsets.UTF_8);
        }
        return ArrayUtil.EMPTY_BYTE_ARRAY;
    }

    @NotNull
    public InputStream openContentStream() {
        if (this.myBytes != null) {
            return new ByteArrayInputStream(this.myBytes);
        }
        if (this.myTemporaryFile != null) {
            try {
                return Files.newInputStream(this.myTemporaryFile, new OpenOption[0]);
            }
            catch (IOException e) {
                LOG.error("Failed to read attachment content from temp. file " + this.myTemporaryFile, e);
            }
        }
        if (this.myDisplayText != null) {
            return new ByteArrayInputStream(this.myDisplayText.getBytes(StandardCharsets.UTF_8));
        }
        return new ByteArrayInputStream(ArrayUtil.EMPTY_BYTE_ARRAY);
    }

    public boolean isIncluded() {
        return this.myIncluded;
    }

    public void setIncluded(boolean included) {
        this.myIncluded = included;
    }
}

