/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components;

import com.intellij.diagnostic.ActivityCategory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.BaseComponent;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionDescriptor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.messages.MessageBus;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.PicoContainer;

@ApiStatus.NonExtendable
public interface ComponentManager
extends UserDataHolder,
Disposable,
AreaInstance {
    @Deprecated
    @Nullable
    default public BaseComponent getComponent(@NotNull String name) {
        return null;
    }

    public <T> T getComponent(@NotNull Class<T> var1);

    default public boolean hasComponent(@NotNull Class<?> interfaceClass) {
        return this.getPicoContainer().getComponentAdapter(interfaceClass) != null;
    }

    @Deprecated
    public <T> T @NotNull [] getComponents(@NotNull Class<T> var1);

    @ApiStatus.Internal
    @NotNull
    public PicoContainer getPicoContainer();

    @ApiStatus.Internal
    public boolean isInjectionForExtensionSupported();

    @NotNull
    public MessageBus getMessageBus();

    public boolean isDisposed();

    @Deprecated
    default public <T> T @NotNull [] getExtensions(@NotNull ExtensionPointName<T> extensionPointName) {
        return this.getExtensionArea().getExtensionPoint(extensionPointName).getExtensions();
    }

    @NotNull
    public Condition<?> getDisposed();

    @Deprecated
    default public <T> T getService(@NotNull Class<T> serviceClass, boolean createIfNeeded) {
        if (createIfNeeded) {
            return this.getService(serviceClass);
        }
        return this.getServiceIfCreated(serviceClass);
    }

    public <T> T getService(@NotNull Class<T> var1);

    @ApiStatus.Experimental
    @NotNull
    default public <T> List<T> getServices(@NotNull Class<T> serviceClass, boolean includeLocal) {
        T service = this.getService(serviceClass);
        return service != null ? Collections.singletonList(service) : Collections.emptyList();
    }

    @Nullable
    default public <T> T getServiceIfCreated(@NotNull Class<T> serviceClass) {
        return this.getService(serviceClass);
    }

    @Override
    @NotNull
    default public ExtensionsArea getExtensionArea() {
        throw new AbstractMethodError();
    }

    @ApiStatus.Internal
    default public <T> T instantiateClass(@NotNull Class<T> aClass, @NotNull PluginId pluginId) {
        return ReflectionUtil.newInstance(aClass, false);
    }

    @ApiStatus.Internal
    public <T> T instantiateClassWithConstructorInjection(@NotNull Class<T> var1, @NotNull Object var2, @NotNull PluginId var3);

    @ApiStatus.Internal
    default public void logError(@NotNull Throwable error, @NotNull PluginId pluginId) {
        throw this.createError(error, pluginId);
    }

    @ApiStatus.Internal
    @NotNull
    public RuntimeException createError(@NotNull Throwable var1, @NotNull PluginId var2);

    @ApiStatus.Internal
    @NotNull
    public RuntimeException createError(@NotNull @NonNls String var1, @NotNull PluginId var2);

    @NotNull
    public RuntimeException createError(@NotNull @NonNls String var1, @Nullable Throwable var2, @NotNull PluginId var3, @Nullable Map<String, String> var4);

    @ApiStatus.Internal
    @NotNull
    public <T> Class<T> loadClass(@NotNull String var1, @NotNull PluginDescriptor var2) throws ClassNotFoundException;

    @ApiStatus.Internal
    @NotNull
    default public <T> T instantiateClass(@NotNull String className, @NotNull PluginDescriptor pluginDescriptor) {
        try {
            return ReflectionUtil.newInstance(this.loadClass(className, pluginDescriptor));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public ActivityCategory getActivityCategory(boolean var1);

    @ApiStatus.Internal
    default public boolean isSuitableForOs(@NotNull ExtensionDescriptor.Os os) {
        return true;
    }
}

