/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.undo;

import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.UndoConstants;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public final class UndoUtil {
    private UndoUtil() {
    }

    public static void markPsiFileForUndo(@NotNull PsiFile file2) {
        Project project = file2.getProject();
        Document document = PsiDocumentManager.getInstance(project).getDocument(file2);
        if (document == null) {
            return;
        }
        CommandProcessor.getInstance().addAffectedDocuments(project, document);
    }

    public static void disableUndoFor(@NotNull Document document) {
        document.putUserData(UndoConstants.DONT_RECORD_UNDO, Boolean.TRUE);
    }

    public static void disableUndoIn(@NotNull Document document, @NotNull Runnable runnable) {
        document.putUserData(UndoConstants.DONT_RECORD_UNDO, Boolean.TRUE);
        try {
            runnable.run();
        }
        finally {
            document.putUserData(UndoConstants.DONT_RECORD_UNDO, null);
        }
    }

    public static void disableUndoFor(@NotNull VirtualFile file2) {
        file2.putUserData(UndoConstants.DONT_RECORD_UNDO, Boolean.TRUE);
    }

    public static void enableUndoFor(@NotNull Document document) {
        document.putUserData(UndoConstants.DONT_RECORD_UNDO, null);
    }

    public static boolean isUndoDisabledFor(@NotNull Document document) {
        return Boolean.TRUE.equals(document.getUserData(UndoConstants.DONT_RECORD_UNDO));
    }

    public static boolean isUndoDisabledFor(@NotNull VirtualFile file2) {
        return Boolean.TRUE.equals(file2.getUserData(UndoConstants.DONT_RECORD_UNDO));
    }

    public static void forceUndoIn(@NotNull VirtualFile file2, @NotNull Runnable runnable) {
        file2.putUserData(UndoConstants.FORCE_RECORD_UNDO, Boolean.TRUE);
        try {
            runnable.run();
        }
        finally {
            file2.putUserData(UndoConstants.FORCE_RECORD_UNDO, null);
        }
    }

    public static void setForceUndoFlag(@NotNull VirtualFile file2, boolean flag) {
        file2.putUserData(UndoConstants.FORCE_RECORD_UNDO, flag ? Boolean.TRUE : null);
    }

    public static boolean isForceUndoFlagSet(@NotNull VirtualFile file2) {
        return file2.getUserData(UndoConstants.FORCE_RECORD_UNDO) == Boolean.TRUE;
    }
}

