/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.BaseActionRunnable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.RunResult;
import com.intellij.openapi.application.WriteThread;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ThrowableRunnable;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public abstract class WriteAction<T>
extends BaseActionRunnable<T> {
    private static final Logger LOG = Logger.getInstance(WriteAction.class);

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public WriteAction() {
    }

    @Override
    @Deprecated
    @NotNull
    public RunResult<T> execute() {
        RunResult result = new RunResult(this);
        Application application = ApplicationManager.getApplication();
        if (application.isWriteThread()) {
            try (AccessToken ignored = ApplicationManager.getApplication().acquireWriteActionLock(this.getClass());){
                result.run();
            }
            return result;
        }
        if (application.isReadAccessAllowed()) {
            LOG.error("Must not start write action from within read action in the other thread - deadlock is coming");
        }
        WriteThread.invokeAndWait(() -> {
            try (AccessToken ignored = ApplicationManager.getApplication().acquireWriteActionLock(this.getClass());){
                result.run();
            }
        });
        result.throwException();
        return result;
    }

    @Deprecated
    @NotNull
    @ApiStatus.ScheduledForRemoval
    public static AccessToken start() {
        Class<WriteAction> callerClass = ObjectUtils.notNull(ReflectionUtil.getCallerClass(3), WriteAction.class);
        return ApplicationManager.getApplication().acquireWriteActionLock(callerClass);
    }

    public static <E extends Throwable> void run(@NotNull ThrowableRunnable<E> action) throws E {
        ApplicationManager.getApplication().runWriteAction(() -> {
            action.run();
            return null;
        });
    }

    public static <T, E extends Throwable> T compute(@NotNull ThrowableComputable<T, E> action) throws E {
        return ApplicationManager.getApplication().runWriteAction(action);
    }

    @Override
    @Deprecated
    protected abstract void run(@NotNull Result<? super T> var1) throws Throwable;

    public static <E extends Throwable> void runAndWait(@NotNull ThrowableRunnable<E> action) throws E {
        WriteAction.computeAndWait(() -> {
            action.run();
            return null;
        });
    }

    public static <T, E extends Throwable> T computeAndWait(@NotNull ThrowableComputable<T, E> action) throws E {
        return WriteAction.computeAndWait(action, ModalityState.defaultModalityState());
    }

    public static <T, E extends Throwable> T computeAndWait(@NotNull ThrowableComputable<T, E> action, ModalityState modalityState) throws E {
        Application application = ApplicationManager.getApplication();
        if (application.isWriteThread()) {
            return ApplicationManager.getApplication().runWriteAction(action);
        }
        if (SwingUtilities.isEventDispatchThread()) {
            LOG.error("You can't run blocking actions from EDT in Pure UI mode");
        }
        if (application.isReadAccessAllowed()) {
            LOG.error("Must not start write action from within read action in the other thread - deadlock is coming");
        }
        AtomicReference result = new AtomicReference();
        AtomicReference exception = new AtomicReference();
        WriteThread.invokeAndWait(() -> {
            try {
                result.set(WriteAction.compute(action));
            }
            catch (Throwable e) {
                exception.set(e);
            }
        }, modalityState);
        Throwable t = (Throwable)exception.get();
        if (t != null) {
            t.addSuppressed(new RuntimeException());
            ExceptionUtil.rethrowUnchecked(t);
            throw t;
        }
        return (T)result.get();
    }
}

