/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.application.ApplicationManager;
import java.awt.Component;
import org.jetbrains.annotations.NotNull;

public abstract class ModalityState {
    @NotNull
    public static final ModalityState NON_MODAL;

    @NotNull
    public static ModalityState current() {
        return ApplicationManager.getApplication().getCurrentModalityState();
    }

    @NotNull
    public static ModalityState any() {
        return ApplicationManager.getApplication().getAnyModalityState();
    }

    @NotNull
    public static ModalityState stateForComponent(@NotNull Component component) {
        return ApplicationManager.getApplication().getModalityStateForComponent(component);
    }

    @NotNull
    public static ModalityState defaultModalityState() {
        return ApplicationManager.getApplication().getDefaultModalityState();
    }

    public abstract boolean dominates(@NotNull ModalityState var1);

    public abstract String toString();

    static {
        try {
            Class<?> ex = Class.forName("com.intellij.openapi.application.impl.ModalityStateEx");
            NON_MODAL = (ModalityState)ex.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException(e);
        }
    }
}

