/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.fasterxml.aalto.in.ReaderConfig;
import com.intellij.diff.comparison.ComparisonUtil;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.text.Strings;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.util.lang.UrlClassLoader;
import com.intellij.util.xml.dom.XmlDomReader;
import com.sun.jna.TypeMapper;
import com.sun.jna.platform.FileUtils;
import gnu.trove.THashSet;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Collection;
import java.util.HashSet;
import kotlin.Pair;
import net.jpountz.lz4.LZ4Factory;
import org.apache.log4j.Appender;
import org.apache.oro.text.regex.PatternMatcher;
import org.codehaus.stax2.XMLStreamReader2;
import org.intellij.lang.annotations.Flow;
import org.jdom.Document;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.xxh3.Xx3UnencodedString;

@ApiStatus.Internal
public final class ClassPathUtil {
    private ClassPathUtil() {
    }

    @NotNull
    public static Collection<String> getUtilClassPath() {
        Class<?>[] classes = ClassPathUtil.getUtilClasses();
        HashSet<String> classPath = new HashSet<String>(classes.length);
        for (Class<?> aClass : classes) {
            String path = PathManager.getJarPathForClass(aClass);
            if (path == null) continue;
            classPath.add(path);
        }
        ClassPathUtil.addKotlinStdlib(classPath);
        return classPath;
    }

    public static void addKotlinStdlib(@NotNull Collection<String> classPath) {
        classPath.add(PathManager.getResourceRoot(PathManager.class, "/kotlin/jdk7/AutoCloseableKt.class"));
        classPath.add(PathManager.getResourceRoot(PathManager.class, "/kotlin/streams/jdk8/StreamsKt.class"));
    }

    @NotNull
    public static @NotNull Class<?> @NotNull [] getUtilClasses() {
        Class[] classes = new Class[]{PathManager.class, Strings.class, XmlDomReader.class, MinusculeMatcher.class, SystemInfoRt.class, ComparisonUtil.class, UrlClassLoader.class, Xx3UnencodedString.class, Flow.class, Document.class, Appender.class, Object2IntMap.class, THashSet.class, TypeMapper.class, FileUtils.class, PatternMatcher.class, LZ4Factory.class, ReaderConfig.class, XMLStreamReader2.class, Pair.class};
        return classes;
    }
}

