/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.xml.dom.XmlDomReader;
import com.intellij.util.xml.dom.XmlElement;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ApplicationNamesInfo {
    private final String myProductName;
    private final String myFullProductName;
    private final String myEditionName;
    private final String myScriptName;
    private final String myDefaultLauncherName;
    private final String myMotto;
    private static volatile ApplicationNamesInfo instance;

    @NotNull
    private static XmlElement loadData() {
        String prefix = System.getProperty("idea.platform.prefix", "");
        if (Boolean.getBoolean("idea.use.dev.build.server")) {
            String module = null;
            if (prefix.isEmpty() || prefix.equals("idea")) {
                module = "intellij.idea.ultimate.resources";
            } else if (prefix.equals("WebStorm")) {
                module = "intellij.webstorm";
            }
            if (module != null) {
                Path file2 = Paths.get(PathManager.getHomePath() + "/out/classes/production/" + module + "/idea/" + (prefix.equals("idea") ? "" : prefix) + "ApplicationInfo.xml", new String[0]);
                try {
                    return XmlDomReader.readXmlAsModel(Files.newInputStream(file2, new OpenOption[0]));
                }
                catch (NoSuchFileException noSuchFileException) {
                }
                catch (Exception e) {
                    throw new RuntimeException("Cannot load " + file2, e);
                }
            }
        } else {
            String customAppInfo;
            if ((prefix.equals("Gateway") || prefix.equals("Qodana")) && (customAppInfo = System.getProperty("idea.application.info.value")) != null) {
                try {
                    Path file3 = Paths.get(customAppInfo, new String[0]);
                    return XmlDomReader.readXmlAsModel(Files.newInputStream(file3, new OpenOption[0]));
                }
                catch (Exception e) {
                    throw new RuntimeException("Cannot load custom application info file " + customAppInfo, e);
                }
            }
            String appInfoData = ApplicationNamesInfo.getAppInfoData();
            if (!appInfoData.isEmpty()) {
                return XmlDomReader.readXmlAsModel(appInfoData.getBytes(StandardCharsets.UTF_8));
            }
        }
        String resource = "idea/" + (prefix.equals("idea") ? "" : prefix) + "ApplicationInfo.xml";
        InputStream stream = ApplicationNamesInfo.class.getClassLoader().getResourceAsStream(resource);
        if (stream == null) {
            throw new RuntimeException("Resource not found: " + resource);
        }
        try {
            return XmlDomReader.readXmlAsModel(stream);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot load resource: " + resource, e);
        }
    }

    private static String getAppInfoData() {
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    @NotNull
    public static XmlElement initAndGetRawData() {
        Class<ApplicationNamesInfo> clazz = ApplicationNamesInfo.class;
        synchronized (ApplicationNamesInfo.class) {
            XmlElement data = ApplicationNamesInfo.loadData();
            if (instance == null) {
                instance = new ApplicationNamesInfo(data);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return data;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static ApplicationNamesInfo getInstance() {
        ApplicationNamesInfo result = instance;
        if (result != null) return result;
        Class<ApplicationNamesInfo> clazz = ApplicationNamesInfo.class;
        synchronized (ApplicationNamesInfo.class) {
            result = instance;
            if (result != null) return result;
            instance = result = new ApplicationNamesInfo(ApplicationNamesInfo.loadData());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return result;
        }
    }

    private ApplicationNamesInfo(@NotNull XmlElement rootElement) {
        XmlElement names = rootElement.getChild("names");
        assert (names != null);
        this.myProductName = names.getAttributeValue("product");
        this.myFullProductName = names.getAttributeValue("fullname", this.myProductName);
        this.myEditionName = names.getAttributeValue("edition");
        this.myScriptName = names.getAttributeValue("script");
        this.myDefaultLauncherName = names.getAttributeValue("default-launcher-name", this.myScriptName);
        this.myMotto = names.getAttributeValue("motto", "The Drive to Develop");
    }

    @NlsSafe
    public String getProductName() {
        return this.myProductName;
    }

    @NlsSafe
    public String getFullProductName() {
        return this.myFullProductName;
    }

    @NlsSafe
    public String getFullProductNameWithEdition() {
        return this.myEditionName == null ? this.myFullProductName : this.myFullProductName + ' ' + this.myEditionName;
    }

    @NlsSafe
    @Nullable
    public String getEditionName() {
        return this.myEditionName;
    }

    public String getLowercaseProductName() {
        String s = this.myProductName.toLowerCase(Locale.ENGLISH);
        return Character.isUpperCase(s.charAt(0)) ? s : Character.toUpperCase(s.charAt(0)) + s.substring(1);
    }

    public String getScriptName() {
        return this.myScriptName;
    }

    public String getDefaultLauncherName() {
        return this.myDefaultLauncherName;
    }

    @NotNull
    public String getMotto() {
        return this.myMotto;
    }
}

