/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.CachedSingletonsRegistry;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.util.Disposer;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class ApplicationManager {
    protected static Application ourApplication;

    public static Application getApplication() {
        return ourApplication;
    }

    private static void setApplication(@NotNull Application instance) {
        ourApplication = instance;
        CachedSingletonsRegistry.cleanupCachedFields();
    }

    public static void setApplication(@NotNull Application instance, @NotNull Disposable parent) {
        Application old = ourApplication;
        Disposer.register(parent, () -> {
            if (old != null) {
                ApplicationManager.setApplication(old);
            }
        });
        ApplicationManager.setApplication(instance);
    }

    public static void setApplication(@NotNull Application instance, @NotNull Supplier<? extends FileTypeRegistry> fileTypeRegistryGetter, @NotNull Disposable parent) {
        Application old = ourApplication;
        ApplicationManager.setApplication(instance);
        Supplier<? extends FileTypeRegistry> oldFileTypeRegistry = FileTypeRegistry.setInstanceSupplier(fileTypeRegistryGetter);
        Disposer.register(parent, () -> {
            if (old != null) {
                ApplicationManager.setApplication(old);
                FileTypeRegistry.setInstanceSupplier(oldFileTypeRegistry);
            }
        });
    }
}

