/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.model.psi;

import com.intellij.model.Symbol;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public interface PsiSymbolReference {
    @NotNull
    public PsiElement getElement();

    @NotNull
    public TextRange getRangeInElement();

    @NotNull
    default public TextRange getAbsoluteRange() {
        return this.getRangeInElement().shiftRight(this.getElement().getTextRange().getStartOffset());
    }

    @NotNull
    public Collection<? extends Symbol> resolveReference();

    default public boolean resolvesTo(@NotNull Symbol target) {
        return ContainerUtil.or(this.resolveReference(), it -> it.equals(target));
    }

    @NotNull
    public static String getReferenceText(@NotNull PsiSymbolReference reference) {
        return reference.getRangeInElement().substring(reference.getElement().getText());
    }
}

