/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.model.presentation;

import com.intellij.model.presentation.SymbolPresentationImpl;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import javax.swing.Icon;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface SymbolPresentation {
    @Nullable
    default public Icon getIcon() {
        return null;
    }

    @NlsSafe
    @NotNull
    public String getShortNameString();

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getShortDescription();

    @NlsContexts.DetailedDescription
    @NotNull
    default public String getLongDescription() {
        return this.getShortDescription();
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static SymbolPresentation create(@NlsSafe @NotNull String shortNameString, @Nls(capitalization=Nls.Capitalization.Sentence) @NotNull String shortDescription) {
        return SymbolPresentation.create(null, shortNameString, shortDescription, shortDescription);
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static SymbolPresentation create(@Nullable Icon icon, @NlsSafe @NotNull String shortNameString, @Nls(capitalization=Nls.Capitalization.Sentence) @NotNull String shortDescription) {
        return SymbolPresentation.create(icon, shortNameString, shortDescription, shortDescription);
    }

    @Contract(value="_, _, _, _ -> new")
    @NotNull
    public static SymbolPresentation create(@Nullable Icon icon, @NlsSafe @NotNull String shortNameString, @Nls(capitalization=Nls.Capitalization.Sentence) @NotNull String shortDescription, @NlsContexts.DetailedDescription @NotNull String longDescription) {
        return new SymbolPresentationImpl(icon, shortNameString, shortDescription, longDescription);
    }
}

