/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.model;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public interface SideEffectGuard {
    public boolean isAllowed(@NotNull EffectType var1);

    public static void checkSideEffectAllowed(@NotNull EffectType effectType) {
        SideEffectGuard guard = ApplicationManager.getApplication().getService(SideEffectGuard.class);
        if (guard != null && !guard.isAllowed(effectType)) {
            throw new SideEffectNotAllowedException(effectType);
        }
    }

    public static enum EffectType {
        PROJECT_MODEL,
        SETTINGS,
        EXEC;

    }

    public static final class SideEffectNotAllowedException
    extends IllegalStateException
    implements ControlFlowException {
        public SideEffectNotAllowedException(@NotNull EffectType effectType) {
            super("Side effect not allowed: " + effectType.name());
        }
    }
}

