/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.model;

import com.intellij.model.ModelBranch;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModelBranchUtil {
    private ModelBranchUtil() {
    }

    @NotNull
    public static <T extends PsiElement> T obtainCopyFromTheSameBranch(@NotNull PsiElement context, @NotNull T element) {
        ModelBranch branch = ModelBranch.getPsiBranch(context);
        if (branch == null) {
            return element;
        }
        ModelBranch elementBranch = ModelBranch.getPsiBranch(element);
        if (elementBranch == branch) {
            return element;
        }
        if (elementBranch != null) {
            throw new IllegalArgumentException("Branch of supplied element differs from context branch");
        }
        return branch.obtainPsiCopy(element);
    }

    @NotNull
    public static VirtualFile obtainCopyFromTheSameBranch(@NotNull VirtualFile context, @NotNull VirtualFile file2) {
        ModelBranch branch = ModelBranch.getFileBranch(context);
        if (branch == null) {
            return file2;
        }
        ModelBranch fileBranch = ModelBranch.getFileBranch(file2);
        if (fileBranch == branch) {
            return file2;
        }
        if (fileBranch != null) {
            throw new IllegalArgumentException("Branch of supplied file differs from context branch");
        }
        return branch.findFileCopy(file2);
    }

    @Contract(value="null -> null")
    @Nullable
    public static VirtualFile findOriginalFile(@Nullable VirtualFile file2) {
        if (file2 == null) {
            return null;
        }
        ModelBranch branch = ModelBranch.getFileBranch(file2);
        return branch == null ? file2 : branch.findOriginalFile(file2);
    }

    @Contract(value="null -> null")
    @Nullable
    public static <T extends PsiElement> T findOriginalPsi(@Nullable T psi) {
        if (psi == null) {
            return null;
        }
        ModelBranch branch = ModelBranch.getPsiBranch(psi);
        return branch == null ? psi : branch.findOriginalPsi(psi);
    }

    @Nullable
    public static <T> T getAndResetCopyableUserData(PsiElement element, Key<T> key) {
        ModelBranch branch = ModelBranch.getPsiBranch(element);
        PsiElement original = branch == null ? null : branch.findOriginalPsi(element);
        T data = ObjectUtils.notNull(original, element).getCopyableUserData(key);
        if (data != null) {
            if (original != null) {
                branch.runAfterMerge(() -> original.putCopyableUserData(key, null));
            } else {
                element.putCopyableUserData(key, null);
            }
        }
        return data;
    }

    public static void checkSameBranch(@NotNull VirtualFile left, @NotNull VirtualFile right) {
        ModelBranch rightBranch;
        ModelBranch leftBranch = ModelBranch.getFileBranch(left);
        if (leftBranch != (rightBranch = ModelBranch.getFileBranch(right))) {
            throw new IllegalArgumentException("Files from different branches: " + leftBranch + " vs " + rightBranch);
        }
    }
}

