/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lexer;

import com.intellij.lexer.FlexLexer;
import com.intellij.lexer.LexerBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class FlexAdapter
extends LexerBase {
    private static final Logger LOG = Logger.getInstance(FlexAdapter.class);
    private final FlexLexer myFlex;
    private IElementType myTokenType;
    private CharSequence myText;
    private int myTokenStart;
    private int myTokenEnd;
    private int myBufferEnd;
    private int myState;
    private boolean myFailed;

    public FlexAdapter(@NotNull FlexLexer flex) {
        this.myFlex = flex;
    }

    public FlexLexer getFlex() {
        return this.myFlex;
    }

    @Override
    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        this.myText = buffer;
        this.myTokenStart = this.myTokenEnd = startOffset;
        this.myBufferEnd = endOffset;
        this.myFlex.reset(this.myText, startOffset, endOffset, initialState);
        this.myTokenType = null;
    }

    @Override
    public int getState() {
        this.locateToken();
        return this.myState;
    }

    @Override
    public IElementType getTokenType() {
        this.locateToken();
        return this.myTokenType;
    }

    @Override
    public int getTokenStart() {
        this.locateToken();
        return this.myTokenStart;
    }

    @Override
    public int getTokenEnd() {
        this.locateToken();
        return this.myTokenEnd;
    }

    @Override
    public void advance() {
        this.locateToken();
        this.myTokenType = null;
    }

    @Override
    @NotNull
    public CharSequence getBufferSequence() {
        return this.myText;
    }

    @Override
    public int getBufferEnd() {
        return this.myBufferEnd;
    }

    protected void locateToken() {
        if (this.myTokenType != null) {
            return;
        }
        this.myTokenStart = this.myTokenEnd;
        if (this.myFailed) {
            return;
        }
        try {
            this.myState = this.myFlex.yystate();
            this.myTokenType = this.myFlex.advance();
            this.myTokenEnd = this.myFlex.getTokenEnd();
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            this.myFailed = true;
            this.myTokenType = TokenType.BAD_CHARACTER;
            this.myTokenEnd = this.myBufferEnd;
            LOG.warn(this.myFlex.getClass().getName(), e);
        }
    }

    public String toString() {
        return "FlexAdapter for " + this.myFlex.getClass().getName();
    }
}

