/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.folding;

import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.FoldingBuilderEx;
import com.intellij.lang.folding.LanguageFolding;
import com.intellij.openapi.editor.FoldingGroup;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.BitUtil;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FoldingDescriptor {
    public static final FoldingDescriptor[] EMPTY = new FoldingDescriptor[0];
    private static final byte FLAG_NEVER_EXPANDS = 1;
    private static final byte FLAG_COLLAPSED_BY_DEFAULT_DEFINED = 2;
    private static final byte FLAG_COLLAPSED_BY_DEFAULT = 4;
    private static final byte FLAG_CAN_BE_REMOVED_WHEN_COLLAPSED = 8;
    private static final byte FLAG_GUTTER_MARK_ENABLED_FOR_SINGLE_LINE = 16;
    private final ASTNode myElement;
    private final TextRange myRange;
    @Nullable
    private final FoldingGroup myGroup;
    private final Set<Object> myDependencies;
    private String myPlaceholderText;
    private byte myFlags;

    public FoldingDescriptor(@NotNull ASTNode node, @NotNull TextRange range) {
        this(node, range, null);
    }

    public FoldingDescriptor(@NotNull PsiElement element, @NotNull TextRange range) {
        this(Objects.requireNonNull(element.getNode()), range, null);
    }

    public FoldingDescriptor(@NotNull ASTNode node, @NotNull TextRange range, @Nullable FoldingGroup group) {
        this(node, range, group, Collections.emptySet());
    }

    public FoldingDescriptor(@NotNull ASTNode node, @NotNull TextRange range, @Nullable FoldingGroup group, Set<Object> dependencies) {
        this(node, range, group, dependencies, false);
    }

    public FoldingDescriptor(@NotNull ASTNode node, @NotNull TextRange range, @Nullable FoldingGroup group, Set<Object> dependencies, boolean neverExpands) {
        this(node, range, group, dependencies, neverExpands, null, null);
    }

    public FoldingDescriptor(@NotNull PsiElement e, int start, int end, @Nullable FoldingGroup group, @NotNull String placeholderText) {
        this(e.getNode(), new TextRange(start, end), group, placeholderText);
    }

    public FoldingDescriptor(@NotNull ASTNode node, @NotNull TextRange range, @Nullable FoldingGroup group, @NotNull String placeholderText) {
        this(node, range, group, Collections.emptySet(), false, placeholderText, null);
    }

    public FoldingDescriptor(@NotNull ASTNode node, @NotNull TextRange range, @Nullable FoldingGroup group, @NotNull String placeholderText, @Nullable(value="null means FoldingBuilder.isCollapsedByDefault will be used") @Nullable(value="null means FoldingBuilder.isCollapsedByDefault will be used") Boolean collapsedByDefault, @NotNull Set<Object> dependencies) {
        this(node, range, group, dependencies, false, placeholderText, collapsedByDefault);
    }

    public FoldingDescriptor(@NotNull ASTNode node, @NotNull TextRange range, @Nullable FoldingGroup group, @NotNull Set<Object> dependencies, boolean neverExpands, @Nullable(value="null means FoldingBuilder.getPlaceholderText will be used") @Nullable(value="null means FoldingBuilder.getPlaceholderText will be used") String placeholderText, @Nullable(value="null means FoldingBuilder.isCollapsedByDefault will be used") @Nullable(value="null means FoldingBuilder.isCollapsedByDefault will be used") Boolean collapsedByDefault) {
        assert (range.getLength() > 0) : range + ", text: " + node.getText() + ", language = " + node.getPsi().getLanguage();
        if (neverExpands && group != null) {
            throw new IllegalArgumentException("'Never-expanding' region cannot be part of a group");
        }
        this.myElement = node;
        this.myRange = range;
        this.myGroup = group;
        this.myDependencies = dependencies;
        try {
            assert (dependencies.isEmpty() || !dependencies.contains(null));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.myPlaceholderText = placeholderText;
        this.setFlag((byte)1, neverExpands);
        if (collapsedByDefault != null) {
            this.setFlag((byte)2, true);
            this.setFlag((byte)4, collapsedByDefault);
        }
    }

    @NotNull
    public ASTNode getElement() {
        return this.myElement;
    }

    @NotNull
    public TextRange getRange() {
        return this.myRange;
    }

    @Nullable
    public FoldingGroup getGroup() {
        return this.myGroup;
    }

    @Nullable
    public String getPlaceholderText() {
        return this.myPlaceholderText == null ? this.calcPlaceholderText() : this.myPlaceholderText;
    }

    @ApiStatus.Internal
    final String getCachedPlaceholderText() {
        return this.myPlaceholderText;
    }

    public void setPlaceholderText(@Nullable(value="null means FoldingBuilder.getPlaceholderText will be used") @Nullable(value="null means FoldingBuilder.getPlaceholderText will be used") String placeholderText) {
        this.myPlaceholderText = placeholderText;
    }

    String calcPlaceholderText() {
        PsiElement psiElement = this.myElement.getPsi();
        if (psiElement == null) {
            return null;
        }
        FoldingBuilder foldingBuilder = LanguageFolding.INSTANCE.forLanguage(psiElement.getLanguage());
        if (foldingBuilder == null) {
            return null;
        }
        return foldingBuilder instanceof FoldingBuilderEx ? ((FoldingBuilderEx)foldingBuilder).getPlaceholderText(this.myElement, this.myRange) : foldingBuilder.getPlaceholderText(this.myElement);
    }

    @NotNull
    public Set<Object> getDependencies() {
        return this.myDependencies;
    }

    public boolean isNonExpandable() {
        return this.getFlag((byte)1);
    }

    public boolean canBeRemovedWhenCollapsed() {
        return this.getFlag((byte)8);
    }

    @Nullable
    public Boolean isCollapsedByDefault() {
        return this.getFlag((byte)2) ? Boolean.valueOf(this.getFlag((byte)4)) : null;
    }

    public void setCanBeRemovedWhenCollapsed(boolean canBeRemovedWhenCollapsed) {
        this.setFlag((byte)8, canBeRemovedWhenCollapsed);
    }

    public boolean isGutterMarkEnabledForSingleLine() {
        return this.getFlag((byte)16);
    }

    public void setGutterMarkEnabledForSingleLine(boolean value) {
        this.setFlag((byte)16, value);
    }

    private boolean getFlag(byte mask) {
        return BitUtil.isSet(this.myFlags, mask);
    }

    private void setFlag(byte mask, boolean value) {
        this.myFlags = BitUtil.set(this.myFlags, mask, value);
    }

    public String toString() {
        return this.myRange + " for AST: " + this.myElement;
    }
}

