/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageFilter;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class CompositeLanguage
extends Language {
    private final ConcurrentList<LanguageFilter> myFilters = ContainerUtil.createConcurrentList();

    protected CompositeLanguage(@NotNull String id) {
        super(id);
    }

    protected CompositeLanguage(@NotNull String ID2, String ... mimeTypes) {
        super(ID2, mimeTypes);
    }

    protected CompositeLanguage(@NotNull Language baseLanguage, @NotNull String ID2, String ... mimeTypes) {
        super(baseLanguage, ID2, mimeTypes);
    }

    public void registerLanguageExtension(@NotNull LanguageFilter filter) {
        this.myFilters.addIfAbsent(filter);
    }

    @ApiStatus.Internal
    public boolean unregisterLanguageExtension(@NotNull LanguageFilter filter) {
        return this.myFilters.remove(filter);
    }

    public Language @NotNull [] getLanguageExtensionsForFile(@NotNull PsiFile psi) {
        ArrayList<Language> extensions = new ArrayList<Language>(1);
        for (LanguageFilter filter : this.myFilters) {
            if (!filter.isRelevantForFile(psi)) continue;
            extensions.add(filter.getLanguage());
        }
        return extensions.toArray(new Language[0]);
    }

    public LanguageFilter @NotNull [] getLanguageExtensions() {
        return this.myFilters.toArray(new LanguageFilter[0]);
    }
}

