/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.analytics;

import com.intellij.internal.statistic.analytics.StudioCrashDetails;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.SystemInfo;
import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public class StudioCrashDetection {
    private static final String RECORD_FILE_KEY = "studio.record.file";
    private static final String PLATFORM_PREFIX = "AndroidStudio";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static ArrayList<StudioCrashDetails> ourCrashes;

    private StudioCrashDetection() {
    }

    public static void start() {
        block10: {
            if (System.getProperty(RECORD_FILE_KEY) != null) {
                throw new AssertionError((Object)"StudioCrashDetection.start called more than once");
            }
            try {
                File f = new File(PathManager.getTempPath(), String.format("%s.%s", PLATFORM_PREFIX, UUID.randomUUID().toString()));
                if (!f.createNewFile()) break block10;
                System.setProperty(RECORD_FILE_KEY, f.getAbsolutePath());
                try (FileWriter fw = new FileWriter(f);){
                    List<String> lines;
                    File buildInfo = new File(PathManager.getHomePath(), "build.txt");
                    if (!buildInfo.exists() && SystemInfo.isMac) {
                        buildInfo = new File(PathManager.getHomePath(), "Resources/build.txt");
                    }
                    String buildVersion = "<unknown>";
                    if (buildInfo.exists() && !(lines = Files.readAllLines(buildInfo.toPath())).isEmpty()) {
                        buildVersion = lines.get(0);
                    }
                    fw.write(buildVersion);
                    fw.write(LINE_SEPARATOR);
                    fw.write(System.getProperty("java.runtime.version"));
                    fw.write(LINE_SEPARATOR);
                    fw.write(String.valueOf(ManagementFactory.getRuntimeMXBean().getStartTime()));
                    fw.write(LINE_SEPARATOR);
                    fw.write(String.valueOf(StudioCrashDetection.getMyPID()));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static long getMyPID() {
        String pidAndMachineName = ManagementFactory.getRuntimeMXBean().getName();
        String[] split = pidAndMachineName.split("@");
        long pid = -1L;
        if (split.length == 2) {
            try {
                pid = Long.parseLong(split[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return pid;
    }

    public static void updateRecordedVersionNumber(@NotNull String version) {
        String recordFileName = System.getProperty(RECORD_FILE_KEY);
        if (recordFileName != null) {
            File recordFile = new File(recordFileName);
            try {
                List<String> lines = Files.readAllLines(recordFile.toPath());
                lines.set(0, version);
                try (FileWriter fw = new FileWriter(recordFile);){
                    for (String line : lines) {
                        fw.write(line);
                        fw.write(LINE_SEPARATOR);
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void stop() {
        String recordFileName = System.getProperty(RECORD_FILE_KEY);
        if (recordFileName != null) {
            try {
                Files.deleteIfExists(Paths.get(recordFileName, new String[0]));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            System.clearProperty(RECORD_FILE_KEY);
        }
    }

    public static List<StudioCrashDetails> reapCrashDescriptions() {
        if (ourCrashes != null) {
            return ourCrashes;
        }
        File[] previousRecords = new File(PathManager.getTempPath()).listFiles(new FileFilter(){
            final String recordFile = System.getProperty("studio.record.file");

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().startsWith(StudioCrashDetection.PLATFORM_PREFIX) && !pathname.getAbsolutePath().equals(this.recordFile);
            }
        });
        ourCrashes = new ArrayList();
        if (previousRecords != null) {
            for (File record : previousRecords) {
                StudioCrashDetails crash;
                try {
                    crash = StudioCrashDetails.loadFromRecordFile(record);
                }
                catch (IOException ignored) {
                    crash = StudioCrashDetails.UNKNOWN;
                }
                try {
                    if (!Files.deleteIfExists(record.toPath())) continue;
                    ourCrashes.add(crash);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return ourCrashes;
    }
}

