/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.analytics;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Scanner;
import org.jetbrains.annotations.NotNull;

public class StudioCrashDetails {
    public static final StudioCrashDetails UNKNOWN = new StudioCrashDetails("<unknown>", false, -1L, "", "", "", "");
    private static final String JVM_CRASH_FILE_STRING_FORMAT = System.getProperty("user.home") + File.separator + "java_error_in_STUDIO_%d.log";
    private final String myDescription;
    private final boolean myJvmCrash;
    private final long myUptimeInMs;
    private final String myErrorSignal;
    private final String myErrorFrame;
    private final String myErrorThread;
    private final String myNativeStack;

    private StudioCrashDetails(String description, boolean isJvmCrash, long uptimeInMs, String errorSignal, String errorFrame, String errorThread, String nativeStack) {
        this.myDescription = description;
        this.myJvmCrash = isJvmCrash;
        this.myUptimeInMs = uptimeInMs;
        this.myErrorSignal = errorSignal;
        this.myErrorFrame = errorFrame;
        this.myErrorThread = errorThread;
        this.myNativeStack = nativeStack;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public static StudioCrashDetails loadFromRecordFile(File record) throws IOException {
        block18: {
            lines = Files.readAllLines(record.toPath());
            buildNumber = lines.isEmpty() == false ? lines.get(0) : "";
            runtimeVersion = lines.size() > 1 ? lines.get(1) : "";
            startupDateInMs = -1L;
            if (lines.size() > 2) {
                try {
                    startupDateInMs = Long.parseLong(lines.get(2));
                }
                catch (NumberFormatException var6_5) {
                    // empty catch block
                }
            }
            pid = -1L;
            if (lines.size() > 3) {
                try {
                    pid = Long.parseLong(lines.get(3));
                }
                catch (NumberFormatException var8_7) {
                    // empty catch block
                }
            }
            isJvmCrash = false;
            uptimeInMs = -1L;
            errorSignal = "";
            errorFrame = "";
            errorThread = "";
            nativeStack = "";
            if (startupDateInMs == -1L || pid < 0L || !Files.exists(jvmCrashReportFile = Paths.get(String.format(StudioCrashDetails.JVM_CRASH_FILE_STRING_FORMAT, new Object[]{pid}), new String[0]), new LinkOption[0]) || (crashDateInMs = (attrs = Files.readAttributes(jvmCrashReportFile, BasicFileAttributes.class, new LinkOption[0])).creationTime().toMillis()) <= startupDateInMs) break block18;
            isJvmCrash = true;
            uptimeInMs = crashDateInMs - startupDateInMs;
            scanner = new Scanner(jvmCrashReportFile);
lbl28:
            // 2 sources

            try {
                block9: while (scanner.hasNext() && (errorSignal.isEmpty() || errorFrame.isEmpty() || errorThread.isEmpty() || nativeStack.isEmpty())) {
                    block19: {
                        if (scanner.findInLine("#  SIG") != null) {
                            errorSignal = "SIG" + scanner.nextLine();
                            continue;
                        }
                        if (scanner.findInLine("#  EXCEPTION") != null) {
                            errorSignal = "EXCEPTION" + scanner.nextLine();
                            continue;
                        }
                        if (scanner.findInLine("# Problematic frame:") != null) {
                            scanner.nextLine();
                            errorFrame = scanner.nextLine().substring(2);
                            continue;
                        }
                        if (scanner.findInLine("Current thread \\(.+\\):") != null) {
                            errorThread = scanner.nextLine().trim();
                            continue;
                        }
                        if (scanner.findInLine("Native frames:") == null) break block19;
                        scanner.nextLine();
                        nativeStackBuilder = new StringBuilder();
                        while (scanner.hasNext()) {
                            line = scanner.nextLine();
                            if (line.isEmpty()) {
                                nativeStack = nativeStackBuilder.toString();
                                continue block9;
                            }
                            nativeStackBuilder.append(line.trim()).append('\n');
                        }
                        ** GOTO lbl28
                    }
                    scanner.nextLine();
                }
            }
            finally {
                scanner.close();
            }
        }
        description = buildNumber + "\n" + runtimeVersion;
        return new StudioCrashDetails(description, isJvmCrash, uptimeInMs, (String)errorSignal, errorFrame, errorThread, nativeStack);
    }

    public boolean isJvmCrash() {
        return this.myJvmCrash;
    }

    public String getDescription() {
        return this.myDescription;
    }

    public long getUptimeInMs() {
        return this.myUptimeInMs;
    }

    public String getErrorSignal() {
        return this.myErrorSignal;
    }

    public String getErrorFrame() {
        return this.myErrorFrame;
    }

    public String getErrorThread() {
        return this.myErrorThread;
    }

    public String getNativeStack() {
        return this.myNativeStack;
    }
}

