/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.idea;

import com.intellij.ide.BootstrapBundle;
import com.intellij.ide.BootstrapClassLoaderUtil;
import com.intellij.ide.WindowsCommandLineProcessor;
import com.intellij.ide.startup.StartupActionScriptManager;
import com.intellij.internal.statistic.analytics.StudioCrashDetection;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.lang.PathClassLoader;
import java.awt.AWTError;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public final class Main {
    public static final int NO_GRAPHICS = 1;
    public static final int RESTART_FAILED = 2;
    public static final int STARTUP_EXCEPTION = 3;
    public static final int JDK_CHECK_FAILED = 4;
    public static final int DIR_CHECK_FAILED = 5;
    public static final int INSTANCE_CHECK_FAILED = 6;
    public static final int LICENSE_ERROR = 7;
    public static final int PLUGIN_ERROR = 8;
    public static final int PRIVACY_POLICY_REJECTION = 11;
    public static final int INSTALLATION_CORRUPTED = 12;
    public static final int ACTIVATE_WRONG_TOKEN_CODE = 13;
    public static final int ACTIVATE_NOT_INITIALIZED = 14;
    public static final int ACTIVATE_ERROR = 15;
    public static final int ACTIVATE_DISPOSING = 16;
    public static final String FORCE_PLUGIN_UPDATES = "idea.force.plugin.updates";
    public static final String CWM_HOST_COMMAND = "cwmHost";
    public static final String CWM_HOST_NO_LOBBY_COMMAND = "cwmHostNoLobby";
    private static final String MAIN_RUNNER_CLASS_NAME = "com.intellij.idea.StartupUtil";
    private static final String AWT_HEADLESS = "java.awt.headless";
    private static final String PLATFORM_PREFIX_PROPERTY = "idea.platform.prefix";
    private static final List<String> HEADLESS_COMMANDS = List.of("ant", "duplocate", "dump-shared-index", "traverseUI", "buildAppcodeCache", "format", "keymap", "update", "inspections", "intentions", "rdserver-headless", "thinClient-headless", "installPlugins", "dumpActions", "cwmHostStatus", "warmup", "buildEventsScheme", "inspectopedia-generator", "remoteDevShowHelp", "installGatewayProtocolHandler", "uninstallGatewayProtocolHandler", "appcodeClangModulesDiff", "appcodeClangModulesPrinter", "exit");
    private static final List<String> GUI_COMMANDS = List.of("diff", "merge");
    private static boolean isHeadless;
    private static boolean isCommandLine;
    private static boolean hasGraphics;
    private static boolean isLightEdit;
    private static boolean isRemoteDevHost;

    private Main() {
    }

    public static void main(String[] args2) {
        LinkedHashMap<String, Long> startupTimings = new LinkedHashMap<String, Long>(6);
        startupTimings.put("startup begin", System.nanoTime());
        if (args2.length == 1 && "%f".equals(args2[0])) {
            args2 = new String[]{};
        }
        Main.setFlags(args2);
        try {
            Main.bootstrap(args2, startupTimings);
        }
        catch (Throwable t) {
            Main.showMessage(BootstrapBundle.message("bootstrap.error.title.start.failed", new Object[0]), t);
            System.exit(3);
        }
    }

    private static void bootstrap(String[] args2, LinkedHashMap<String, Long> startupTimings) throws Throwable {
        startupTimings.put("properties loading", System.nanoTime());
        PathManager.loadProperties();
        if (Main.isStudio() && !Main.isHeadless()) {
            StudioCrashDetection.start();
        }
        startupTimings.put("plugin updates install", System.nanoTime());
        if (!isCommandLine || Boolean.getBoolean(FORCE_PLUGIN_UPDATES)) {
            boolean configImportNeeded;
            boolean bl = configImportNeeded = !Main.isHeadless() && !Files.exists(Path.of(PathManager.getConfigPath(), new String[0]), new LinkOption[0]);
            if (!configImportNeeded) {
                Main.installPluginUpdates();
            }
        }
        startupTimings.put("classloader init", System.nanoTime());
        PathClassLoader newClassLoader = BootstrapClassLoaderUtil.initClassLoader(isRemoteDevHost);
        Thread.currentThread().setContextClassLoader(newClassLoader);
        startupTimings.put("MainRunner search", System.nanoTime());
        Class<?> mainClass = newClassLoader.loadClassInsideSelf(MAIN_RUNNER_CLASS_NAME, "com/intellij/idea/StartupUtil.class", -635775336887217634L, true);
        if (mainClass == null) {
            throw new ClassNotFoundException(MAIN_RUNNER_CLASS_NAME);
        }
        WindowsCommandLineProcessor.ourMainRunnerClass = mainClass;
        MethodHandles.lookup().findStatic(mainClass, "start", MethodType.methodType(Void.TYPE, String.class, Boolean.TYPE, Boolean.TYPE, String[].class, LinkedHashMap.class)).invokeExact(Main.class.getName() + "Impl", isHeadless, newClassLoader != Main.class.getClassLoader(), args2, startupTimings);
    }

    private static void installPluginUpdates() {
        try {
            Path scriptFile = Path.of(PathManager.getPluginTempPath(), "action.script");
            if (Files.isRegularFile(scriptFile, new LinkOption[0])) {
                StartupActionScriptManager.executeActionScript();
            }
        }
        catch (IOException e) {
            Main.showMessage("Plugin Installation Error", "The IDE failed to install or update some plugins.\nPlease try again, and if the problem persists, please report it\nto https://jb.gg/ide/critical-startup-errors\n\nThe cause: " + e, false);
        }
    }

    public static boolean isHeadless() {
        return isHeadless;
    }

    public static boolean isCommandLine() {
        return isCommandLine;
    }

    public static boolean isLightEdit() {
        return isLightEdit;
    }

    public static void setFlags(String @NotNull [] args2) {
        isHeadless = Main.isHeadless(args2);
        isCommandLine = isHeadless || args2.length > 0 && GUI_COMMANDS.contains(args2[0]);
        boolean bl = isRemoteDevHost = args2.length > 0 && (CWM_HOST_COMMAND.equals(args2[0]) || CWM_HOST_NO_LOBBY_COMMAND.equals(args2[0]));
        if (isHeadless) {
            System.setProperty(AWT_HEADLESS, Boolean.TRUE.toString());
        }
        isLightEdit = "LightEdit".equals(System.getProperty(PLATFORM_PREFIX_PROPERTY)) || !isCommandLine && Main.isFileAfterOptions(args2);
    }

    private static boolean isFileAfterOptions(String @NotNull [] args2) {
        for (String arg2 : args2) {
            if (!arg2.startsWith("-")) {
                try {
                    Path path = Path.of(arg2, new String[0]);
                    return Files.isRegularFile(path, new LinkOption[0]) || !Files.exists(path, new LinkOption[0]);
                }
                catch (Throwable t) {
                    return false;
                }
            }
            if (!arg2.equals("-l") && !arg2.equals("--line") && !arg2.equals("-c") && !arg2.equals("--column")) continue;
            return true;
        }
        return false;
    }

    @TestOnly
    public static void setHeadlessInTestMode(boolean headless) {
        isHeadless = headless;
        isCommandLine = true;
        isLightEdit = false;
    }

    private static boolean isHeadless(String[] args2) {
        if (Boolean.getBoolean(AWT_HEADLESS)) {
            return true;
        }
        if (args2.length == 0) {
            return false;
        }
        String firstArg = args2[0];
        return HEADLESS_COMMANDS.contains(firstArg) || firstArg.length() < 20 && firstArg.endsWith("inspect");
    }

    private static boolean isStudio() {
        return "AndroidStudio".equalsIgnoreCase(System.getProperty(PLATFORM_PREFIX_PROPERTY));
    }

    public static void showMessage(@Nls(capitalization=Nls.Capitalization.Title) String title, Throwable t) {
        @Nls(capitalization=Nls.Capitalization.Sentence) StringWriter message = new StringWriter();
        AWTError awtError = Main.findGraphicsError(t);
        if (awtError != null) {
            message.append(BootstrapBundle.message("bootstrap.error.message.failed.to.initialize.graphics.environment", new Object[0]));
            message.append("\n\n");
            hasGraphics = false;
            t = awtError;
        } else {
            message.append(BootstrapBundle.message("bootstrap.error.message.internal.error.please.refer.to.0", Main.supportUrl()));
            message.append("\n\n");
        }
        t.printStackTrace(new PrintWriter(message));
        message.append("\n-----\n").append(BootstrapBundle.message("bootstrap.error.message.jre.details", Main.jreDetails()));
        Main.showMessage(title, message.toString(), true);
    }

    private static AWTError findGraphicsError(Throwable t) {
        while (t != null) {
            if (t instanceof AWTError) {
                return (AWTError)t;
            }
            t = t.getCause();
        }
        return null;
    }

    @NlsSafe
    private static String jreDetails() {
        Properties sp = System.getProperties();
        String jre = sp.getProperty("java.runtime.version", sp.getProperty("java.version", "(unknown)"));
        String vendor = sp.getProperty("java.vendor", "(unknown vendor)");
        String arch = sp.getProperty("os.arch", "(unknown arch)");
        String home = sp.getProperty("java.home", "(unknown java.home)");
        return jre + " " + arch + " (" + vendor + ")\n" + home;
    }

    @NlsSafe
    private static String supportUrl() {
        boolean studio = "AndroidStudio".equalsIgnoreCase(System.getProperty(PLATFORM_PREFIX_PROPERTY));
        return studio ? "https://code.google.com/p/android/issues" : "https://jb.gg/ide/critical-startup-errors";
    }

    public static void showMessage(@Nls(capitalization=Nls.Capitalization.Title) String title, @Nls(capitalization=Nls.Capitalization.Sentence) String message, boolean error) {
        PrintStream stream = error ? System.err : System.out;
        stream.println();
        stream.println(title);
        stream.println(message);
        if (!hasGraphics || Main.isCommandLine() || GraphicsEnvironment.isHeadless() || isRemoteDevHost) {
            return;
        }
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            JTextPane textPane = new JTextPane();
            textPane.setEditable(false);
            textPane.setText(message.replaceAll("\t", "    "));
            textPane.setBackground(UIManager.getColor("Panel.background"));
            textPane.setCaretPosition(0);
            JScrollPane scrollPane = new JScrollPane(textPane, 20, 30);
            scrollPane.setBorder(null);
            int maxHeight = Toolkit.getDefaultToolkit().getScreenSize().height / 2;
            int maxWidth = Toolkit.getDefaultToolkit().getScreenSize().width / 2;
            Dimension component = scrollPane.getPreferredSize();
            if (component.height > maxHeight || component.width > maxWidth) {
                scrollPane.setPreferredSize(new Dimension(Math.min(maxWidth, component.width), Math.min(maxHeight, component.height)));
            }
            int type = error ? 0 : 2;
            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), scrollPane, title, type);
        }
        catch (Throwable t) {
            stream.println("\nAlso, a UI exception occurred on an attempt to show the above message");
            t.printStackTrace(stream);
        }
    }

    static {
        hasGraphics = true;
    }
}

