/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates;

import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.util.NlsSafe;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileTemplateDescriptor {
    private final String myFileName;
    private final Icon myIcon;

    public FileTemplateDescriptor(@NotNull String fileName) {
        this(fileName, FileTypeRegistry.getInstance().getFileTypeByFileName(fileName).getIcon());
    }

    public FileTemplateDescriptor(@NotNull String fileName, @Nullable Icon icon) {
        this.myIcon = icon;
        this.myFileName = fileName;
    }

    @NotNull
    @NlsSafe
    public String getDisplayName() {
        return this.getFileName();
    }

    @NotNull
    @NlsSafe
    public String getFileName() {
        return this.myFileName;
    }

    @Nullable
    public Icon getIcon() {
        return this.myIcon;
    }
}

