/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import java.io.Serializable;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public final class ImportSettingsFilenameFilter
implements Predicate<String>,
Serializable {
    public static final String SETTINGS_JAR_MARKER = "IntelliJ IDEA Global Settings";
    private static final long serialVersionUID = 201708031943L;
    private final String[] myRelativeNamesToExtract;

    public ImportSettingsFilenameFilter(@NotNull Set<String> relativeNamesToExtract) {
        this.myRelativeNamesToExtract = relativeNamesToExtract.toArray(new String[0]);
    }

    @Override
    public boolean test(@NotNull String relativePath) {
        if (relativePath.equals(SETTINGS_JAR_MARKER)) {
            return false;
        }
        relativePath = relativePath.replace('\\', '/');
        for (String allowedRelPath : this.myRelativeNamesToExtract) {
            if (!relativePath.startsWith(allowedRelPath)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return Stream.of(this.myRelativeNamesToExtract).sorted().collect(Collectors.joining(",", "ImportSettingsFilenameFilter[", "]"));
    }
}

