/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.util;

import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.PathExecLazyValue;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.io.IdeUtilIoBundle;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010 \u001a\u00020\u0005H\u0002J&\u0010!\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020\u00152\b\b\u0001\u0010$\u001a\u00020\u00152\b\b\u0001\u0010%\u001a\u00020\u0015H\u0007J\u0016\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00150'2\u0006\u0010(\u001a\u00020)H\u0002J\u0016\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00150'2\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u0010+\u001a\u00020\u00152\u0006\u0010,\u001a\u00020\u0015H\u0003J\u0010\u0010-\u001a\u00020\u00152\u0006\u0010,\u001a\u00020\u0015H\u0007J\u0010\u0010.\u001a\u00020/2\u0006\u0010(\u001a\u00020)H\u0007J\u0018\u0010.\u001a\u00020/2\u0006\u0010(\u001a\u00020)2\u0006\u00100\u001a\u000201H\u0007J\u0018\u0010.\u001a\u00020\u00152\u0006\u0010(\u001a\u00020)2\u0006\u00102\u001a\u00020\u0015H\u0007J\u0012\u00103\u001a\u0004\u0018\u00010\u00152\u0006\u0010(\u001a\u00020)H\u0007J\"\u00104\u001a\b\u0012\u0004\u0012\u00020\u00150'2\n\b\u0001\u00105\u001a\u0004\u0018\u00010\u00152\u0006\u00106\u001a\u00020\u0015H\u0007J\b\u00107\u001a\u00020\u0005H\u0007J.\u00108\u001a\u00020\u00152\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020\u00152\u0014\u0010<\u001a\u0010\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0015\u0018\u00010=H\u0007J\u001c\u0010>\u001a\u0004\u0018\u00010\u00152\u0006\u0010?\u001a\u00020@2\b\u0010A\u001a\u0004\u0018\u00010BH\u0007J\u0010\u0010C\u001a\u00020D2\u0006\u0010(\u001a\u00020)H\u0007J\u0010\u0010E\u001a\u00020D2\u0006\u0010(\u001a\u00020)H\u0007J\u001d\u0010F\u001a\u00020G2\u0006\u0010(\u001a\u00020)2\u000b\u0010H\u001a\u00070\u0015\u00a2\u0006\u0002\bIH\u0007J\u001d\u0010J\u001a\u00020/2\u0006\u0010(\u001a\u00020)2\u000b\u0010H\u001a\u00070\u0015\u00a2\u0006\u0002\bIH\u0007J\u001d\u0010K\u001a\u00020)2\u0006\u0010(\u001a\u00020)2\u000b\u0010H\u001a\u00070\u0015\u00a2\u0006\u0002\bIH\u0007R!\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\b\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\t\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\n\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000b\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR!\u0010\u0010\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0011\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0012\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0013\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u00020\u00158\u0002X\u0083T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u00020\u00158GX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0017\u0010\u0002\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u00158GX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u001b\u0010\u0002\u001a\u0004\b\u001c\u0010\u0019R\u001a\u0010\u001d\u001a\u00020\u00158FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u001e\u0010\u0002\u001a\u0004\b\u001f\u0010\u0019\u00a8\u0006L"}, d2={"Lcom/intellij/execution/util/ExecUtil;", "", "()V", "hasGkSudo", "Lcom/intellij/openapi/util/NotNullLazyValue;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "hasGnomeTerminal", "hasKdeSudo", "hasKdeTerminal", "hasNice", "getHasNice", "()Z", "hasNice$delegate", "Lkotlin/Lazy;", "hasPkExec", "hasSetsid", "hasUrxvt", "hasXTerm", "nicePath", "", "openCommandPath", "getOpenCommandPath$annotations", "getOpenCommandPath", "()Ljava/lang/String;", "osascriptPath", "getOsascriptPath$annotations", "getOsascriptPath", "windowsShellName", "getWindowsShellName$annotations", "getWindowsShellName", "canRunLowPriority", "createTempExecutableScript", "Ljava/io/File;", "prefix", "suffix", "content", "envCommand", "", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "envCommandArgs", "escapeAppleScriptArgument", "arg", "escapeUnixShellArgument", "execAndGetOutput", "Lcom/intellij/execution/process/ProcessOutput;", "timeoutInMilliseconds", "", "stdin", "execAndReadLine", "getTerminalCommand", "title", "command", "hasTerminalApp", "loadTemplate", "loader", "Ljava/lang/ClassLoader;", "templateName", "variables", "", "readFirstLine", "stream", "Ljava/io/InputStream;", "cs", "Ljava/nio/charset/Charset;", "setupLowPriorityExecution", "", "setupNoTtyExecution", "sudo", "Ljava/lang/Process;", "prompt", "Lorg/jetbrains/annotations/Nls;", "sudoAndGetOutput", "sudoCommand", "intellij.platform.ide.util.io"})
public final class ExecUtil {
    private static final NotNullLazyValue<Boolean> hasGkSudo;
    private static final NotNullLazyValue<Boolean> hasKdeSudo;
    private static final NotNullLazyValue<Boolean> hasPkExec;
    private static final NotNullLazyValue<Boolean> hasGnomeTerminal;
    private static final NotNullLazyValue<Boolean> hasKdeTerminal;
    private static final NotNullLazyValue<Boolean> hasUrxvt;
    private static final NotNullLazyValue<Boolean> hasXTerm;
    private static final NotNullLazyValue<Boolean> hasSetsid;
    @NlsSafe
    private static final String nicePath = "/usr/bin/nice";
    private static final Lazy hasNice$delegate;
    @NotNull
    public static final ExecUtil INSTANCE;

    private final boolean getHasNice() {
        Lazy lazy = hasNice$delegate;
        ExecUtil execUtil = this;
        Object var3_3 = null;
        return (Boolean)lazy.getValue();
    }

    @JvmStatic
    public static /* synthetic */ void getOsascriptPath$annotations() {
    }

    @NlsSafe
    @NotNull
    public static final String getOsascriptPath() {
        return "/usr/bin/osascript";
    }

    @JvmStatic
    public static /* synthetic */ void getOpenCommandPath$annotations() {
    }

    @NlsSafe
    @NotNull
    public static final String getOpenCommandPath() {
        return "/usr/bin/open";
    }

    @JvmStatic
    public static /* synthetic */ void getWindowsShellName$annotations() {
    }

    @NotNull
    public static final String getWindowsShellName() {
        return CommandLineUtil.getWinShellName();
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final String loadTemplate(@NotNull ClassLoader loader, @NotNull String templateName, @Nullable Map<String, String> variables) throws IOException {
        InputStream inputStream = loader.getResourceAsStream(templateName);
        if (inputStream == null) {
            throw (Throwable)new IOException("Template '" + templateName + "' not found by " + loader);
        }
        InputStream stream = inputStream;
        String template = FileUtil.loadTextAndClose(new InputStreamReader(stream, Charsets.UTF_8));
        Map<String, String> map = variables;
        if (map == null || map.isEmpty()) {
            return template;
        }
        StringBuilder buffer = new StringBuilder(template);
        Object object = variables;
        Iterator<Map.Entry<String, String>> iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            void name;
            Map.Entry<String, String> entry;
            Map.Entry<String, String> entry2 = entry = iterator.next();
            object = entry2.getKey();
            entry2 = entry;
            String value = entry2.getValue();
            int pos = buffer.indexOf((String)name);
            if (pos < 0) continue;
            buffer.replace(pos, pos + name.length(), value);
        }
        return buffer.toString();
    }

    @JvmStatic
    @NotNull
    public static final File createTempExecutableScript(@NlsSafe @NotNull String prefix, @NlsSafe @NotNull String suffix, @NlsSafe @NotNull String content) throws IOException, ExecutionException {
        File tempDir = new File(PathManager.getTempPath());
        File tempFile = FileUtil.createTempFile(tempDir, prefix, suffix, true, true);
        String string2 = content;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        FileUtil.writeToFile(tempFile, byArray);
        if (!tempFile.setExecutable(true, true)) {
            throw (Throwable)new ExecutionException(IdeUtilIoBundle.message("dialog.message.failed.to.make.temp.file.executable", tempFile));
        }
        return tempFile;
    }

    @JvmStatic
    @NotNull
    public static final ProcessOutput execAndGetOutput(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        return new CapturingProcessHandler(commandLine).runProcess();
    }

    @JvmStatic
    @NotNull
    public static final ProcessOutput execAndGetOutput(@NotNull GeneralCommandLine commandLine, int timeoutInMilliseconds) throws ExecutionException {
        return new CapturingProcessHandler(commandLine).runProcess(timeoutInMilliseconds);
    }

    @JvmStatic
    @NotNull
    public static final String execAndGetOutput(@NotNull GeneralCommandLine commandLine, @NotNull String stdin) {
        CapturingProcessHandler capturingProcessHandler;
        CapturingProcessHandler processHandler = capturingProcessHandler = new CapturingProcessHandler(commandLine);
        boolean bl = false;
        processHandler.addProcessListener(new ProcessAdapter(processHandler, commandLine, stdin){
            final /* synthetic */ CapturingProcessHandler $processHandler;
            final /* synthetic */ GeneralCommandLine $commandLine$inlined;
            final /* synthetic */ String $stdin$inlined;
            {
                this.$processHandler = $captured_local_variable$1;
                this.$commandLine$inlined = generalCommandLine;
                this.$stdin$inlined = string2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void startNotified(@NotNull ProcessEvent event) {
                Closeable closeable = this.$processHandler.getProcessInput();
                Object object = this.$commandLine$inlined.getCharset();
                closeable = new OutputStreamWriter((OutputStream)closeable, (Charset)object);
                object = null;
                try {
                    OutputStreamWriter it = (OutputStreamWriter)closeable;
                    boolean bl = false;
                    it.write(this.$stdin$inlined);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
                }
            }
        });
        return capturingProcessHandler.runProcess().getStdout();
    }

    @JvmStatic
    @Nullable
    public static final String execAndReadLine(@NotNull GeneralCommandLine commandLine) {
        String string2;
        try {
            string2 = ExecUtil.readFirstLine(commandLine.createProcess().getInputStream(), commandLine.getCharset());
        }
        catch (ExecutionException e) {
            Logger.getInstance(ExecUtil.class).debug(e);
            string2 = null;
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @Nullable
    public static final String readFirstLine(@NotNull InputStream stream, @Nullable Charset cs) {
        Object object;
        try {
            String string2;
            object = new BufferedReader(cs == null ? new InputStreamReader(stream) : new InputStreamReader(stream, cs));
            Throwable throwable = null;
            try {
                BufferedReader it = (BufferedReader)object;
                boolean bl = false;
                string2 = it.readLine();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            object = string2;
        }
        catch (IOException e) {
            Logger.getInstance(ExecUtil.class).debug(e);
            object = null;
        }
        return object;
    }

    @JvmStatic
    @NotNull
    public static final Process sudo(@NotNull GeneralCommandLine commandLine, @NotNull String prompt) throws ExecutionException, IOException {
        return ExecUtil.sudoCommand(commandLine, prompt).createProcess();
    }

    @JvmStatic
    @NotNull
    public static final GeneralCommandLine sudoCommand(@NotNull GeneralCommandLine commandLine, @NotNull String prompt) throws ExecutionException, IOException {
        GeneralCommandLine generalCommandLine;
        if (SystemInfo.isUnix && Intrinsics.areEqual((Object)"root", (Object)System.getenv("USER"))) {
            return commandLine;
        }
        List command = CollectionsKt.mutableListOf((Object[])new String[]{commandLine.getExePath()});
        Collection collection = command;
        Iterable iterable = commandLine.getParametersList().getList();
        CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
        if (SystemInfoRt.isWindows) {
            Path launcherExe = PathManager.findBinFileWithException("launcher.exe");
            generalCommandLine = new GeneralCommandLine(CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])new String[]{((Object)launcherExe).toString(), commandLine.getExePath()}), (Iterable)commandLine.getParametersList().getParameters()));
        } else if (SystemInfoRt.isMac) {
            String escapedCommand2 = StringUtil.join(command, (Function)sudoCommand.sudoCommandLine.escapedCommand.1.INSTANCE, " & \" \" & ");
            String messageArg = " with prompt \"" + StringUtil.escapeQuotes(prompt) + "\"";
            String escapedScript = "tell current application\n   activate\n   do shell script " + escapedCommand2 + messageArg + " with administrator privileges without altering line endings\nend tell";
            generalCommandLine = new GeneralCommandLine(ExecUtil.getOsascriptPath(), "-e", escapedScript);
        } else if (hasGkSudo.getValue().booleanValue()) {
            generalCommandLine = new GeneralCommandLine(CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])new String[]{"gksudo", "--message", prompt, "--"}), (Iterable)INSTANCE.envCommand(commandLine)), (Iterable)command));
        } else if (hasKdeSudo.getValue().booleanValue()) {
            generalCommandLine = new GeneralCommandLine(CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])new String[]{"kdesudo", "--comment", prompt, "--"}), (Iterable)INSTANCE.envCommand(commandLine)), (Iterable)command));
        } else if (hasPkExec.getValue().booleanValue()) {
            generalCommandLine = new GeneralCommandLine(CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)"pkexec"), (Iterable)INSTANCE.envCommand(commandLine)), (Iterable)command));
        } else if (ExecUtil.hasTerminalApp()) {
            String escapedCommandLine2 = StringUtil.join(command, (Function)sudoCommand.sudoCommandLine.escapedCommandLine.1.INSTANCE, " ");
            List<String> args2 = INSTANCE.envCommandArgs(commandLine);
            String escapedEnvCommand2 = Intrinsics.areEqual(args2, (Object)CollectionsKt.emptyList()) ? "" : "env " + StringUtil.join((Collection)args2, (Function)sudoCommand.sudoCommandLine.escapedEnvCommand.1.INSTANCE, " ") + " ";
            File script = ExecUtil.createTempExecutableScript("sudo", ".sh", "#!/bin/sh\necho " + ExecUtil.escapeUnixShellArgument(prompt) + "\necho\nsudo -- " + escapedEnvCommand2 + escapedCommandLine2 + "\nSTATUS=$?\necho\nread -p \"Press Enter to close this window...\" TEMP\nexit $STATUS\n");
            generalCommandLine = new GeneralCommandLine(ExecUtil.getTerminalCommand(IdeUtilIoBundle.message("terminal.title.install", new Object[0]), script.getAbsolutePath()));
        } else {
            throw (Throwable)new UnsupportedOperationException("Cannot `sudo` on this system - no suitable utils found");
        }
        GeneralCommandLine sudoCommandLine2 = generalCommandLine;
        GeneralCommandLine.ParentEnvironmentType parentEnvType = SystemInfoRt.isWindows ? GeneralCommandLine.ParentEnvironmentType.NONE : commandLine.getParentEnvironmentType();
        return sudoCommandLine2.withWorkDirectory(commandLine.getWorkDirectory()).withEnvironment(commandLine.getEnvironment()).withParentEnvironmentType(parentEnvType).withRedirectErrorStream(commandLine.isRedirectErrorStream());
    }

    private final List<String> envCommand(GeneralCommandLine commandLine) {
        List<String> args2 = this.envCommandArgs(commandLine);
        return Intrinsics.areEqual(args2, (Object)CollectionsKt.emptyList()) ? CollectionsKt.emptyList() : CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)"env"), (Iterable)args2);
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> envCommandArgs(GeneralCommandLine commandLine) {
        List list;
        Map<String, String> env = commandLine.getEnvironment();
        if (Intrinsics.areEqual(env, (Object)MapsKt.emptyMap())) {
            list = CollectionsKt.emptyList();
        } else {
            void $this$mapTo$iv$iv;
            Map<String, String> $this$map$iv = env;
            boolean $i$f$map = false;
            Map<String, String> map = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                void entry;
                Map.Entry item$iv$iv;
                Map.Entry entry2 = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string2 = (String)entry.getKey() + "=" + (String)entry.getValue();
                collection.add(string2);
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }

    @JvmStatic
    @NotNull
    public static final ProcessOutput sudoAndGetOutput(@NotNull GeneralCommandLine commandLine, @NotNull String prompt) throws IOException, ExecutionException {
        return ExecUtil.execAndGetOutput(ExecUtil.sudoCommand(commandLine, prompt));
    }

    @NlsSafe
    private final String escapeAppleScriptArgument(String arg2) {
        return "quoted form of \"" + StringsKt.replace$default((String)StringsKt.replace$default((String)arg2, (String)"\"", (String)"\\\"", (boolean)false, (int)4, null), (String)"\\", (String)"\\\\", (boolean)false, (int)4, null) + "\"";
    }

    @JvmStatic
    @NotNull
    public static final String escapeUnixShellArgument(@NotNull String arg2) {
        return "'" + StringsKt.replace$default((String)arg2, (String)"'", (String)"'\"'\"'", (boolean)false, (int)4, null) + "'";
    }

    @JvmStatic
    public static final boolean hasTerminalApp() {
        return SystemInfo.isWindows || SystemInfo.isMac || hasKdeTerminal.getValue() != false || hasGnomeTerminal.getValue() != false || hasUrxvt.getValue() != false || hasXTerm.getValue() != false;
    }

    @JvmStatic
    @NlsSafe
    @NotNull
    public static final List<String> getTerminalCommand(@Nls(capitalization=Nls.Capitalization.Title) @Nullable String title, @NotNull String command) {
        List list;
        if (SystemInfo.isWindows) {
            Object[] objectArray = new String[5];
            objectArray[0] = ExecUtil.getWindowsShellName();
            objectArray[1] = "/c";
            objectArray[2] = "start";
            String string2 = title;
            if (string2 == null || (string2 = StringsKt.replace$default((String)string2, (char)'\"', (char)'\'', (boolean)false, (int)4, null)) == null) {
                string2 = "";
            }
            objectArray[3] = GeneralCommandLine.inescapableQuote(string2);
            objectArray[4] = command;
            list = CollectionsKt.listOf((Object[])objectArray);
        } else if (SystemInfo.isMac) {
            list = CollectionsKt.listOf((Object[])new String[]{ExecUtil.getOpenCommandPath(), "-a", "Terminal", command});
        } else if (hasKdeTerminal.getValue().booleanValue()) {
            list = title != null ? CollectionsKt.listOf((Object[])new String[]{"konsole", "-p", "tabtitle=\"" + StringsKt.replace$default((String)title, (char)'\"', (char)'\'', (boolean)false, (int)4, null) + "\"", "-e", command}) : CollectionsKt.listOf((Object[])new String[]{"konsole", "-e", command});
        } else if (hasGnomeTerminal.getValue().booleanValue()) {
            list = title != null ? CollectionsKt.listOf((Object[])new String[]{"gnome-terminal", "-t", title, "-x", command}) : CollectionsKt.listOf((Object[])new String[]{"gnome-terminal", "-x", command});
        } else if (hasUrxvt.getValue().booleanValue()) {
            list = title != null ? CollectionsKt.listOf((Object[])new String[]{"urxvt", "-title", title, "-e", command}) : CollectionsKt.listOf((Object[])new String[]{"urxvt", "-e", command});
        } else if (hasXTerm.getValue().booleanValue()) {
            list = title != null ? CollectionsKt.listOf((Object[])new String[]{"xterm", "-T", title, "-e", command}) : CollectionsKt.listOf((Object[])new String[]{"xterm", "-e", command});
        } else {
            throw (Throwable)new UnsupportedOperationException("Unsupported OS/desktop: " + SystemInfo.OS_NAME + "/" + System.getenv("XDG_CURRENT_DESKTOP"));
        }
        return list;
    }

    @JvmStatic
    public static final void setupLowPriorityExecution(@NotNull GeneralCommandLine commandLine) {
        if (INSTANCE.canRunLowPriority()) {
            String executablePath = commandLine.getExePath();
            if (SystemInfo.isWindows) {
                commandLine.setExePath(ExecUtil.getWindowsShellName());
                commandLine.getParametersList().prependAll("/c", "start", "/b", "/low", "/wait", GeneralCommandLine.inescapableQuote(""), executablePath);
            } else {
                commandLine.setExePath(nicePath);
                commandLine.getParametersList().prependAll("-n", "10", executablePath);
            }
        }
    }

    private final boolean canRunLowPriority() {
        return Registry.is("ide.allow.low.priority.process") && (SystemInfo.isWindows || this.getHasNice());
    }

    @JvmStatic
    public static final void setupNoTtyExecution(@NotNull GeneralCommandLine commandLine) {
        if (SystemInfo.isLinux && hasSetsid.getValue().booleanValue()) {
            String executablePath = commandLine.getExePath();
            commandLine.setExePath("setsid");
            commandLine.getParametersList().prependAll(executablePath);
        }
    }

    private ExecUtil() {
    }

    static {
        ExecUtil execUtil;
        INSTANCE = execUtil = new ExecUtil();
        hasGkSudo = PathExecLazyValue.create("gksudo");
        hasKdeSudo = PathExecLazyValue.create("kdesudo");
        hasPkExec = PathExecLazyValue.create("pkexec");
        hasGnomeTerminal = PathExecLazyValue.create("gnome-terminal");
        hasKdeTerminal = PathExecLazyValue.create("konsole");
        hasUrxvt = PathExecLazyValue.create("urxvt");
        hasXTerm = PathExecLazyValue.create("xterm");
        hasSetsid = PathExecLazyValue.create("setsid");
        hasNice$delegate = LazyKt.lazy((Function0)hasNice.2.INSTANCE);
    }

    public static final /* synthetic */ String access$escapeAppleScriptArgument(ExecUtil $this, String arg2) {
        return $this.escapeAppleScriptArgument(arg2);
    }
}

