/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated(forRemoval=true)
public final class WinRunnerMediator {
    private static final Logger LOG = Logger.getInstance(WinRunnerMediator.class);
    private static final char IAC = '\u0005';
    private static final char BRK = '\u0003';
    private static final char C = '\u0005';
    private static final String RUNNERW = "runnerw.exe";
    private static final String IDEA_RUNNERW = "IDEA_RUNNERW";
    private static final Key<Boolean> MEDIATOR_KEY = Key.create("KillableProcessHandler.Mediator.Process");

    private WinRunnerMediator() {
    }

    private static boolean sendCtrlEventThroughStream(@NotNull Process process, char event) {
        OutputStream os = process.getOutputStream();
        if (os != null) {
            try {
                os.write(5);
                os.write(event);
                os.flush();
                return true;
            }
            catch (IOException e) {
                LOG.info("Cannot send \u0005+" + event + " to runnerw", e);
            }
        }
        return false;
    }

    @Nullable
    private static String getRunnerPath() {
        Path runnerw;
        if (!SystemInfo.isWindows) {
            throw new IllegalStateException("There is no need of runner under unix based OS");
        }
        String path = System.getenv(IDEA_RUNNERW);
        if (path != null) {
            if (new File(path).exists()) {
                return path;
            }
            LOG.warn("Cannot locate a runner at " + path + " (as told by IDEA_RUNNERW)");
        }
        if ((runnerw = PathManager.findBinFile(RUNNERW)) != null && Files.exists(runnerw, new LinkOption[0])) {
            return runnerw.toString();
        }
        LOG.warn("Cannot locate runnerw.exe in " + PathManager.getBinPath());
        return null;
    }

    static void injectRunnerCommand(@NotNull GeneralCommandLine commandLine, boolean showConsole) {
        if (!SystemInfo.isWindows || WinRunnerMediator.isRunnerCommandInjected(commandLine)) {
            return;
        }
        String path = WinRunnerMediator.getRunnerPath();
        if (path != null) {
            commandLine.getParametersList().addAt(0, commandLine.getExePath());
            if (showConsole) {
                commandLine.getParametersList().addAt(0, "/C");
            }
            commandLine.setExePath(path);
            MEDIATOR_KEY.set(commandLine, true);
        }
    }

    static boolean isRunnerCommandInjected(@NotNull GeneralCommandLine commandLine) {
        return MEDIATOR_KEY.get(commandLine) == Boolean.TRUE;
    }

    static boolean destroyProcess(@NotNull Process process, boolean softKill) {
        if (SystemInfo.isWindows) {
            return WinRunnerMediator.sendCtrlEventThroughStream(process, softKill ? (char)'\u0005' : '\u0003');
        }
        return false;
    }

    public static void withExternalConsole(@NotNull GeneralCommandLine commandLine) {
        WinRunnerMediator.injectRunnerCommand(commandLine, true);
    }
}

