/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.execution.process.ProcessService;
import com.intellij.execution.process.WinProcessTerminator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Key;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000.\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0010\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a(\u0010\f\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000eH\u0001\u00a8\u0006\u000f"}, d2={"awaitBatchQuestionAndDestroyInTests", "", "questionFoundOrTerminated", "Ljava/util/concurrent/CompletableFuture;", "Ljava/lang/Void;", "processHandler", "Lcom/intellij/execution/process/KillableProcessHandler;", "destroyIfAlive", "isCmdBatchFile", "", "processService", "Lcom/intellij/execution/process/ProcessService;", "terminateWinProcessGracefully", "terminateGracefully", "Lkotlin/Function0;", "intellij.platform.ide.util.io"})
@JvmName(name="WinProcessTerminator")
public final class WinProcessTerminator {
    @JvmOverloads
    public static final boolean terminateWinProcessGracefully(@NotNull KillableProcessHandler processHandler, @NotNull ProcessService processService, @NotNull Function0<Boolean> terminateGracefully) {
        CompletableFuture<Void> questionFoundOrTerminated = new CompletableFuture<Void>();
        ProcessAdapter processListener2 = new ProcessAdapter(processHandler, questionFoundOrTerminated){
            final /* synthetic */ KillableProcessHandler $processHandler;
            final /* synthetic */ CompletableFuture $questionFoundOrTerminated;

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key<?> outputType) {
                if (ProcessOutputType.isStdout(outputType) && StringsKt.contains$default((CharSequence)event.getText(), (CharSequence)"?", (boolean)false, (int)2, null)) {
                    this.$processHandler.removeProcessListener(this);
                    this.$questionFoundOrTerminated.complete(null);
                }
            }

            public void processTerminated(@NotNull ProcessEvent event) {
                this.$processHandler.removeProcessListener(this);
                this.$questionFoundOrTerminated.complete(null);
            }
            {
                this.$processHandler = $captured_local_variable$0;
                this.$questionFoundOrTerminated = $captured_local_variable$1;
            }
        };
        processHandler.addProcessListener(processListener2);
        Object object = terminateGracefully.invoke();
        boolean it = (Boolean)object;
        boolean bl = false;
        if (it) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                if (WinProcessTerminator.isCmdBatchFile(processHandler, processService)) {
                    WinProcessTerminator.awaitBatchQuestionAndDestroyInTests(questionFoundOrTerminated, processHandler);
                }
                processHandler.removeProcessListener(processListener2);
            } else {
                questionFoundOrTerminated.whenComplete(new BiConsumer(processHandler, processService, questionFoundOrTerminated, processListener2){
                    final /* synthetic */ KillableProcessHandler $processHandler$inlined;
                    final /* synthetic */ ProcessService $processService$inlined;
                    final /* synthetic */ CompletableFuture $questionFoundOrTerminated$inlined;
                    final /* synthetic */ terminateWinProcessGracefully.processListener.1 $processListener$inlined;
                    {
                        this.$processHandler$inlined = killableProcessHandler;
                        this.$processService$inlined = processService;
                        this.$questionFoundOrTerminated$inlined = completableFuture;
                        this.$processListener$inlined = var4_4;
                    }

                    public final void accept(Void $noName_0, Throwable $noName_1) {
                        if (!this.$processHandler$inlined.isProcessTerminated() && WinProcessTerminator.access$isCmdBatchFile(this.$processHandler$inlined, this.$processService$inlined)) {
                            WinProcessTerminator.access$destroyIfAlive(this.$processHandler$inlined);
                        }
                    }
                });
            }
        } else {
            processHandler.removeProcessListener(processListener2);
        }
        return (Boolean)object;
    }

    public static /* synthetic */ boolean terminateWinProcessGracefully$default(KillableProcessHandler killableProcessHandler, ProcessService processService, Function0 function0, int n, Object object) {
        if ((n & 4) != 0) {
            function0 = (Function0)new Function0<Boolean>(processService, killableProcessHandler){
                final /* synthetic */ ProcessService $processService;
                final /* synthetic */ KillableProcessHandler $processHandler;

                public final boolean invoke() {
                    return this.$processService.sendWinProcessCtrlC((Process)this.$processHandler.getProcess());
                }
                {
                    this.$processService = processService;
                    this.$processHandler = killableProcessHandler;
                    super(0);
                }
            };
        }
        return WinProcessTerminator.terminateWinProcessGracefully(killableProcessHandler, processService, (Function0<Boolean>)function0);
    }

    @JvmOverloads
    public static final boolean terminateWinProcessGracefully(@NotNull KillableProcessHandler processHandler, @NotNull ProcessService processService) {
        return WinProcessTerminator.terminateWinProcessGracefully$default(processHandler, processService, null, 4, null);
    }

    private static final void awaitBatchQuestionAndDestroyInTests(CompletableFuture<Void> questionFoundOrTerminated, KillableProcessHandler processHandler) {
        try {
            questionFoundOrTerminated.get(10L, TimeUnit.SECONDS);
        }
        catch (Exception exception) {
            return;
        }
        WinProcessTerminator.destroyIfAlive(processHandler);
    }

    private static final void destroyIfAlive(KillableProcessHandler processHandler) {
        if (((Process)processHandler.getProcess()).isAlive()) {
            ((Process)processHandler.getProcess()).destroy();
        }
    }

    private static final boolean isCmdBatchFile(KillableProcessHandler processHandler, ProcessService processService) {
        Object object = CollectionsKt.firstOrNull(processService.getCommand((Process)processHandler.getProcess()));
        String it = (String)object;
        boolean bl = false;
        return it != null && (StringsKt.endsWith$default((String)it, (String)".bat", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)it, (String)".cmd", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)it, (String)"\\cmd.exe", (boolean)false, (int)2, null));
    }

    public static final /* synthetic */ boolean access$isCmdBatchFile(KillableProcessHandler processHandler, ProcessService processService) {
        return WinProcessTerminator.isCmdBatchFile(processHandler, processService);
    }

    public static final /* synthetic */ void access$destroyIfAlive(KillableProcessHandler processHandler) {
        WinProcessTerminator.destroyIfAlive(processHandler);
    }
}

