/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.TaskExecutor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Consumer;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;

public class ProcessWaitFor {
    private static final Logger LOG = Logger.getInstance(ProcessWaitFor.class);
    private final Future<?> myWaitForThreadFuture;
    private final BlockingQueue<Consumer<? super Integer>> myTerminationCallback = new ArrayBlockingQueue<Consumer<? super Integer>>(1);
    private volatile boolean myDetached;

    public ProcessWaitFor(@NotNull Process process, @NotNull TaskExecutor executor, @NotNull String presentableName) {
        this.myWaitForThreadFuture = executor.executeTask(() -> {
            String threadName = StringUtil.isEmptyOrSpaces(presentableName) ? Thread.currentThread().getName() : presentableName;
            ConcurrencyUtil.runUnderThreadName(threadName, () -> {
                int exitCode = 0;
                try {
                    while (!this.myDetached) {
                        try {
                            exitCode = process.waitFor();
                            break;
                        }
                        catch (InterruptedException e) {
                            if (this.myDetached) continue;
                            LOG.debug(e);
                        }
                    }
                }
                catch (Throwable e) {
                    LOG.error(e);
                    throw e;
                }
                finally {
                    if (!this.myDetached) {
                        try {
                            this.myTerminationCallback.take().consume((Object)exitCode);
                        }
                        catch (InterruptedException e) {
                            LOG.info(e);
                        }
                    }
                }
            });
        });
    }

    public void detach() {
        this.myDetached = true;
        this.myWaitForThreadFuture.cancel(true);
    }

    public void setTerminationCallback(@NotNull Consumer<? super Integer> r) {
        this.myTerminationCallback.offer(r);
    }

    public void waitFor() throws InterruptedException {
        try {
            this.myWaitForThreadFuture.get();
        }
        catch (CancellationException cancellationException) {
        }
        catch (ExecutionException e) {
            LOG.error(e);
        }
    }

    public boolean waitFor(long timeout, @NotNull TimeUnit unit) throws InterruptedException {
        try {
            this.myWaitForThreadFuture.get(timeout, unit);
        }
        catch (ExecutionException e) {
            LOG.error(e);
        }
        catch (CancellationException | TimeoutException exception) {
            // empty catch block
        }
        return this.myWaitForThreadFuture.isDone();
    }
}

