/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.openapi.util.Key;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProcessOutputType
extends Key<Object> {
    public static final ProcessOutputType SYSTEM = new ProcessOutputType("system");
    public static final ProcessOutputType STDOUT = new ProcessOutputType("stdout");
    public static final ProcessOutputType STDERR = new ProcessOutputType("stderr");
    private final ProcessOutputType myStreamType;

    public ProcessOutputType(@NotNull String name, @NotNull ProcessOutputType streamType) {
        super(name);
        this.myStreamType = streamType.getBaseOutputType();
    }

    private ProcessOutputType(@NotNull String name) {
        super(name);
        this.myStreamType = this;
    }

    @NotNull
    public ProcessOutputType getBaseOutputType() {
        return this.myStreamType;
    }

    public boolean isStdout() {
        return this.getBaseOutputType() == STDOUT;
    }

    public boolean isStderr() {
        return this.getBaseOutputType() == STDERR;
    }

    public static boolean isStderr(@NotNull Key<?> key) {
        return key instanceof ProcessOutputType && ((ProcessOutputType)key).isStderr();
    }

    public static boolean isStdout(@NotNull Key<?> key) {
        return key instanceof ProcessOutputType && ((ProcessOutputType)key).isStdout();
    }

    @NotNull
    public static String getKeyNameForLogging(@NotNull Key<?> key) {
        return key.toString().replace("\u001b", "ESC");
    }

    @Nullable
    public static ProcessOutputType tryCast(@NotNull Key<?> key) {
        return key instanceof ProcessOutputType ? (ProcessOutputType)key : null;
    }
}

