/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.util.ArrayUtil;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import java.io.OutputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ProcessHandler
extends UserDataHolderBase {
    private static final Logger LOG = Logger.getInstance(ProcessHandler.class);
    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static final Key<Boolean> SILENTLY_DESTROY_ON_CLOSE = Key.create("SILENTLY_DESTROY_ON_CLOSE");
    public static final Key<Boolean> TERMINATION_REQUESTED = Key.create("TERMINATION_REQUESTED");
    @NotNull
    private final @NotNull List<@NotNull ProcessListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final AtomicReference<State> myState = new AtomicReference<State>(State.INITIAL);
    private final Semaphore myWaitSemaphore;
    private final ProcessListener myEventMulticaster = this.createEventMulticaster();
    private final TasksRunner myAfterStartNotifiedRunner;
    @Nullable
    private volatile Integer myExitCode;

    protected ProcessHandler() {
        this.myWaitSemaphore = new Semaphore();
        this.myWaitSemaphore.down();
        this.myAfterStartNotifiedRunner = new TasksRunner();
        this.myListeners.add(this.myAfterStartNotifiedRunner);
    }

    public void startNotify() {
        if (this.myState.compareAndSet(State.INITIAL, State.RUNNING)) {
            this.myEventMulticaster.startNotified(new ProcessEvent(this));
        } else {
            LOG.error("startNotify called already");
        }
    }

    protected abstract void destroyProcessImpl();

    protected abstract void detachProcessImpl();

    public abstract boolean detachIsDefault();

    public boolean waitFor() {
        try {
            this.myWaitSemaphore.waitFor();
            return true;
        }
        catch (ProcessCanceledException e) {
            return false;
        }
    }

    public boolean waitFor(long timeoutInMilliseconds) {
        try {
            return this.myWaitSemaphore.waitFor(timeoutInMilliseconds);
        }
        catch (ProcessCanceledException e) {
            return false;
        }
    }

    public void destroyProcess() {
        this.myAfterStartNotifiedRunner.execute(() -> {
            if (this.myState.compareAndSet(State.RUNNING, State.TERMINATING)) {
                this.fireProcessWillTerminate(true);
                this.destroyProcessImpl();
            }
        });
    }

    public void detachProcess() {
        this.myAfterStartNotifiedRunner.execute(() -> {
            if (this.myState.compareAndSet(State.RUNNING, State.TERMINATING)) {
                this.fireProcessWillTerminate(false);
                this.detachProcessImpl();
            }
        });
    }

    public boolean isProcessTerminated() {
        return this.myState.get() == State.TERMINATED;
    }

    public boolean isProcessTerminating() {
        return this.myState.get() == State.TERMINATING;
    }

    @Nullable
    public Integer getExitCode() {
        return this.myExitCode;
    }

    public void addProcessListener(@NotNull ProcessListener listener) {
        this.myListeners.add(listener);
    }

    public void addProcessListener(final @NotNull ProcessListener listener, @NotNull Disposable parentDisposable) {
        this.myListeners.add(listener);
        Disposer.register(parentDisposable, new Disposable(){

            @Override
            public void dispose() {
                ProcessHandler.this.myListeners.remove(listener);
            }
        });
    }

    public void removeProcessListener(@NotNull ProcessListener listener) {
        this.myListeners.remove(listener);
    }

    protected void notifyProcessDetached() {
        this.notifyTerminated(0, false);
    }

    protected void notifyProcessTerminated(int exitCode) {
        this.notifyTerminated(exitCode, true);
    }

    private void notifyTerminated(int exitCode, boolean willBeDestroyed) {
        this.myAfterStartNotifiedRunner.execute(() -> {
            block10: {
                LOG.assertTrue(this.isStartNotified(), "Start notify is not called");
                if (this.myState.compareAndSet(State.RUNNING, State.TERMINATING)) {
                    try {
                        this.fireProcessWillTerminate(willBeDestroyed);
                    }
                    catch (Throwable e) {
                        if (ProcessHandler.isCanceledException(e)) break block10;
                        LOG.error(e);
                    }
                }
            }
            if (this.myState.compareAndSet(State.TERMINATING, State.TERMINATED)) {
                try {
                    this.myExitCode = exitCode;
                    this.myEventMulticaster.processTerminated(new ProcessEvent(this, exitCode));
                }
                catch (Throwable e) {
                    if (!ProcessHandler.isCanceledException(e)) {
                        LOG.error(e);
                    }
                }
                finally {
                    this.myWaitSemaphore.up();
                }
            }
        });
    }

    public void notifyTextAvailable(@NotNull String text, @NotNull Key outputType) {
        ProcessEvent event = new ProcessEvent(this, text);
        this.myEventMulticaster.onTextAvailable(event, outputType);
    }

    @Nullable
    public abstract OutputStream getProcessInput();

    private void fireProcessWillTerminate(boolean willBeDestroyed) {
        LOG.assertTrue(this.isStartNotified(), "All events should be fired after startNotify is called");
        this.myEventMulticaster.processWillTerminate(new ProcessEvent(this), willBeDestroyed);
    }

    public boolean isStartNotified() {
        return this.myState.get() != State.INITIAL;
    }

    public boolean isSilentlyDestroyOnClose() {
        return false;
    }

    private ProcessListener createEventMulticaster() {
        Class<ProcessListener> listenerClass = ProcessListener.class;
        return (ProcessListener)Proxy.newProxyInstance(listenerClass.getClassLoader(), new Class[]{listenerClass}, new InvocationHandler(){

            @Override
            public Object invoke(Object object, Method method, Object[] params) throws Throwable {
                for (ProcessListener listener : ProcessHandler.this.myListeners) {
                    try {
                        method.invoke((Object)listener, params);
                    }
                    catch (Throwable e) {
                        if (ProcessHandler.isCanceledException(e)) continue;
                        LOG.error(e);
                    }
                }
                return null;
            }
        });
    }

    private static boolean isCanceledException(Throwable e) {
        boolean value;
        boolean bl = value = e instanceof InvocationTargetException && e.getCause() instanceof ProcessCanceledException;
        if (value) {
            LOG.info(e);
        }
        return value;
    }

    private final class TasksRunner
    extends ProcessAdapter {
        private final List<Runnable> myPendingTasks = new ArrayList<Runnable>();

        private TasksRunner() {
        }

        @Override
        public void startNotified(@NotNull ProcessEvent event) {
            ProcessHandler.this.removeProcessListener(this);
            this.runPendingTasks();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(@NotNull Runnable task) {
            if (ProcessHandler.this.isStartNotified()) {
                task.run();
            } else {
                List<Runnable> list = this.myPendingTasks;
                synchronized (list) {
                    this.myPendingTasks.add(task);
                }
                if (ProcessHandler.this.isStartNotified()) {
                    this.runPendingTasks();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runPendingTasks() {
            Runnable[] runnableArray = this.myPendingTasks;
            synchronized (this.myPendingTasks) {
                Runnable[] tasks = this.myPendingTasks.toArray(ArrayUtil.EMPTY_RUNNABLE_ARRAY);
                this.myPendingTasks.clear();
                // ** MonitorExit[var2_1] (shouldn't be in output)
                for (Runnable task : tasks) {
                    task.run();
                }
                return;
            }
        }
    }

    private static enum State {
        INITIAL,
        RUNNING,
        TERMINATING,
        TERMINATED;

    }
}

