/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.process.ProcessInfo;
import com.intellij.execution.process.ProcessService;
import com.intellij.execution.process.UnixProcessManager;
import com.intellij.execution.process.WinProcessManager;
import com.intellij.execution.process.impl.ProcessListUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OSProcessUtil {
    private static final Logger LOG = Logger.getInstance(OSProcessUtil.class);
    private static String ourPid;

    public static ProcessInfo @NotNull [] getProcessList() {
        return ProcessListUtil.getProcessList();
    }

    public static boolean killProcessTree(@NotNull Process process) {
        if (SystemInfo.isWindows) {
            try {
                Integer pid = ProcessService.getInstance().winPtyChildProcessId(process);
                if (pid != null) {
                    if (pid == -1) {
                        return true;
                    }
                    boolean res = WinProcessManager.kill(pid, true);
                    process.destroy();
                    return res;
                }
                if (Registry.is("disable.winp", false)) {
                    return WinProcessManager.kill(process, true);
                }
                if (!process.isAlive()) {
                    OSProcessUtil.logSkippedActionWithTerminatedProcess(process, "killProcessTree", null);
                    return true;
                }
                ProcessService.getInstance().killWinProcessRecursively(process);
                return true;
            }
            catch (Throwable e) {
                LOG.info("Cannot kill process tree", e);
            }
        } else if (SystemInfo.isUnix) {
            return UnixProcessManager.sendSigKillToProcessTree(process);
        }
        return false;
    }

    public static void killProcess(@NotNull Process process) {
        OSProcessUtil.killProcess(OSProcessUtil.getProcessID(process));
    }

    public static void killProcess(int pid) {
        if (SystemInfo.isWindows) {
            try {
                if (!Registry.is("disable.winp", false)) {
                    try {
                        ProcessService.getInstance().killWinProcess(pid);
                        return;
                    }
                    catch (Throwable e) {
                        LOG.error("Failed to kill process with winp, fallback to default logic", e);
                    }
                }
                WinProcessManager.kill(pid, false);
            }
            catch (Throwable e) {
                LOG.info("Cannot kill process", e);
            }
        } else if (SystemInfo.isUnix) {
            UnixProcessManager.sendSignal(pid, 9);
        }
    }

    public static void terminateProcessGracefully(@NotNull Process process) throws RuntimeException {
        if (SystemInfo.isWindows) {
            if (Registry.is("disable.winp")) {
                throw new UnsupportedOperationException("Cannot terminate process, disable.winp=true");
            }
            try {
                ProcessService.getInstance().sendWinProcessCtrlC(process);
            }
            catch (Exception e) {
                throw new UnsupportedOperationException("Failed to terminate process", e);
            }
        } else if (SystemInfo.isUnix) {
            UnixProcessManager.sendSignal((int)process.pid(), 2);
        } else {
            throw new UnsupportedOperationException("Graceful termination is not supported for " + SystemInfo.getOsNameAndVersion());
        }
    }

    @Deprecated(forRemoval=true)
    public static void terminateProcessGracefully(int pid) throws RuntimeException {
        if (SystemInfo.isWindows) {
            if (Registry.is("disable.winp")) {
                throw new UnsupportedOperationException("Cannot terminate process, disable.winp=true");
            }
            try {
                ProcessService.getInstance().sendWinProcessCtrlC(pid);
            }
            catch (Exception e) {
                throw new UnsupportedOperationException("Failed to terminate process", e);
            }
        } else if (SystemInfo.isUnix) {
            UnixProcessManager.sendSignal(pid, 2);
        } else {
            throw new UnsupportedOperationException("Graceful termination is not supported for " + SystemInfo.getOsNameAndVersion());
        }
    }

    static void logSkippedActionWithTerminatedProcess(@NotNull Process process, @NotNull String actionName, @Nullable String commandLine) {
        Integer pid = null;
        try {
            pid = OSProcessUtil.getProcessID(process);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        LOG.info("Cannot " + actionName + " already terminated process (pid: " + pid + ", command: " + commandLine + ")");
    }

    public static int getProcessID(@NotNull Process process) {
        return (int)process.pid();
    }

    @Deprecated(forRemoval=true)
    public static int getProcessID(@NotNull Process process, Boolean disableWinp) {
        return (int)process.pid();
    }

    public static int getCurrentProcessId() {
        return (int)ProcessHandle.current().pid();
    }

    public static String getApplicationPid() {
        if (ourPid == null) {
            ourPid = String.valueOf(OSProcessUtil.getCurrentProcessId());
        }
        return ourPid;
    }
}

