/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.KillableProcess;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.OSProcessUtil;
import com.intellij.execution.process.ProcessService;
import com.intellij.execution.process.ProcessTreeKiller;
import com.intellij.execution.process.UnixProcessManager;
import com.intellij.execution.process.WinProcessTerminator;
import com.intellij.execution.process.WinRunnerMediator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Set;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KillableProcessHandler
extends OSProcessHandler
implements KillableProcess {
    private static final Logger LOG = Logger.getInstance(KillableProcessHandler.class);
    private boolean myShouldKillProcessSoftly = true;
    private final boolean myMediatedProcess;
    private boolean myShouldKillProcessSoftlyWithWinP = SystemInfo.isWin10OrNewer && Registry.is("use.winp.for.graceful.process.termination");

    public KillableProcessHandler(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        super(commandLine);
        this.myMediatedProcess = WinRunnerMediator.isRunnerCommandInjected(commandLine);
    }

    protected KillableProcessHandler(@NotNull Process process, @NotNull GeneralCommandLine commandLine) {
        super(process, commandLine.getCommandLineString(), commandLine.getCharset());
        this.myMediatedProcess = WinRunnerMediator.isRunnerCommandInjected(commandLine);
    }

    @Deprecated(forRemoval=true)
    public KillableProcessHandler(@NotNull GeneralCommandLine commandLine, boolean withMediator) throws ExecutionException {
        this(KillableProcessHandler.mediate(commandLine, withMediator, false));
    }

    public KillableProcessHandler(@NotNull Process process, String commandLine) {
        super(process, commandLine);
        this.myMediatedProcess = false;
    }

    public KillableProcessHandler(@NotNull Process process, String commandLine, @NotNull Charset charset) {
        this(process, commandLine, charset, null);
    }

    public KillableProcessHandler(@NotNull Process process, String commandLine, @NotNull Charset charset, @Nullable Set<File> filesToDelete) {
        super(process, commandLine, charset, filesToDelete);
        this.myMediatedProcess = false;
    }

    @Deprecated(forRemoval=true)
    @NotNull
    protected static GeneralCommandLine mediate(@NotNull GeneralCommandLine commandLine, boolean withMediator, boolean showConsole) {
        if (withMediator && SystemInfo.isWindows) {
            WinRunnerMediator.injectRunnerCommand(commandLine, showConsole);
        }
        return commandLine;
    }

    public boolean shouldKillProcessSoftly() {
        return this.myShouldKillProcessSoftly;
    }

    public void setShouldKillProcessSoftly(boolean shouldKillProcessSoftly) {
        this.myShouldKillProcessSoftly = shouldKillProcessSoftly;
    }

    private boolean canDestroyProcessGracefully() {
        if (KillableProcessHandler.processCanBeKilledByOS(this.myProcess)) {
            if (SystemInfo.isWindows) {
                return this.hasPty() || this.myMediatedProcess || this.canTerminateGracefullyWithWinP();
            }
            if (SystemInfo.isUnix) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected void destroyProcessImpl() {
        try {
            this.myProcess.getOutputStream().flush();
        }
        catch (IOException e) {
            LOG.warn(e);
        }
        finally {
            this.doDestroyProcess();
        }
    }

    @Override
    protected void notifyProcessTerminated(int exitCode) {
        try {
            super.closeStreams();
        }
        finally {
            super.notifyProcessTerminated(exitCode);
        }
    }

    @Override
    protected void doDestroyProcess() {
        boolean gracefulTerminationAttempted;
        boolean bl = gracefulTerminationAttempted = this.shouldKillProcessSoftly() && this.canDestroyProcessGracefully() && this.destroyProcessGracefully();
        if (!gracefulTerminationAttempted) {
            super.doDestroyProcess();
        }
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.Experimental
    public void setShouldKillProcessSoftlyWithWinP(boolean shouldKillProcessSoftlyWithWinP) {
        this.myShouldKillProcessSoftlyWithWinP = shouldKillProcessSoftlyWithWinP;
    }

    private boolean canTerminateGracefullyWithWinP() {
        return this.myShouldKillProcessSoftlyWithWinP && SystemInfo.isWin10OrNewer && !this.isWslProcess();
    }

    private boolean isWslProcess() {
        boolean wsl;
        List<String> command = KillableProcessHandler.getProcessService().getCommand(this.myProcess);
        String executable = ContainerUtil.getFirstItem(command);
        boolean bl = wsl = executable != null && PathUtil.getFileName(executable).equals("wsl.exe");
        if (wsl) {
            LOG.info("WinP graceful termination does not work for WSL process: " + command);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("[graceful termination with WinP] WSL process: " + wsl + ", process: " + this.myProcess.getClass() + ", command: " + command);
        }
        return wsl;
    }

    protected boolean destroyProcessGracefully() {
        ProcessService processService = KillableProcessHandler.getProcessService();
        if (SystemInfo.isWindows) {
            if (processService.hasControllingTerminal(this.myProcess) && WinProcessTerminator.terminateWinProcessGracefully(this, processService, (Function0<Boolean>)((Function0)this::sendInterruptToPtyProcess))) {
                return true;
            }
            if (this.myMediatedProcess) {
                return WinRunnerMediator.destroyProcess(this.myProcess, true);
            }
            if (this.canTerminateGracefullyWithWinP() && !Registry.is("disable.winp")) {
                try {
                    if (!this.myProcess.isAlive()) {
                        OSProcessUtil.logSkippedActionWithTerminatedProcess(this.myProcess, "destroy", this.getCommandLine());
                        return true;
                    }
                    return WinProcessTerminator.terminateWinProcessGracefully(this, processService);
                }
                catch (Throwable e) {
                    if (!this.myProcess.isAlive()) {
                        OSProcessUtil.logSkippedActionWithTerminatedProcess(this.myProcess, "destroy", this.getCommandLine());
                        return true;
                    }
                    String message = e.getMessage();
                    if (message != null && message.contains(".exe terminated with exit code 6,")) {
                        String msg = "Cannot send Ctrl+C to process without a console (fallback to default termination)";
                        if (LOG.isDebugEnabled()) {
                            LOG.debug(msg + " " + this.getCommandLine());
                        }
                        LOG.info(msg);
                    }
                    LOG.error("Cannot send Ctrl+C (fallback to default termination) " + this.getCommandLine(), e);
                }
            }
        } else if (SystemInfo.isUnix) {
            if (processService.hasControllingTerminal(this.myProcess) && this.sendInterruptToPtyProcess()) {
                return true;
            }
            if (this.shouldDestroyProcessRecursively()) {
                return UnixProcessManager.sendSigIntToProcessTree(this.myProcess);
            }
            return UnixProcessManager.sendSignal(UnixProcessManager.getProcessId(this.myProcess), 2) == 0;
        }
        return false;
    }

    @NotNull
    private static ProcessService getProcessService() {
        return (ProcessService)ProgressManager.getInstance().computeInNonCancelableSection(ProcessService::getInstance);
    }

    private boolean sendInterruptToPtyProcess() {
        OutputStream outputStream = this.myProcess.getOutputStream();
        if (outputStream != null) {
            try {
                outputStream.write(3);
                outputStream.flush();
                return true;
            }
            catch (IOException e) {
                LOG.info("Failed to send Ctrl+C to PTY process. Fallback to default graceful termination.", e);
            }
        }
        return false;
    }

    @Override
    public boolean canKillProcess() {
        return KillableProcessHandler.processCanBeKilledByOS(this.getProcess()) || this.getProcess() instanceof ProcessTreeKiller;
    }

    @Override
    public void killProcess() {
        if (KillableProcessHandler.processCanBeKilledByOS(this.getProcess())) {
            this.killProcessTree((Process)this.getProcess());
        } else if (this.getProcess() instanceof ProcessTreeKiller) {
            ((ProcessTreeKiller)this.getProcess()).killProcessTree();
        }
    }
}

