/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.AnsiEscapeDecoder;
import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.openapi.util.Key;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColoredProcessHandler
extends KillableProcessHandler
implements AnsiEscapeDecoder.ColoredTextAcceptor {
    private final AnsiEscapeDecoder myAnsiEscapeDecoder = new AnsiEscapeDecoder();

    public ColoredProcessHandler(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        super(commandLine);
        this.setShouldKillProcessSoftly(false);
    }

    protected ColoredProcessHandler(@NotNull Process process, @NotNull GeneralCommandLine commandLine) {
        super(process, commandLine);
        this.setShouldKillProcessSoftly(false);
    }

    public ColoredProcessHandler(@NotNull Process process, String commandLine) {
        super(process, commandLine);
        this.setShouldKillProcessSoftly(false);
    }

    public ColoredProcessHandler(@NotNull Process process, String commandLine, @NotNull Charset charset) {
        this(process, commandLine, charset, null);
    }

    public ColoredProcessHandler(@NotNull Process process, String commandLine, @NotNull Charset charset, @Nullable Set<File> filesToDelete) {
        super(process, commandLine, charset, filesToDelete);
        this.setShouldKillProcessSoftly(false);
    }

    @Override
    public final void notifyTextAvailable(@NotNull String text, @NotNull Key outputType) {
        this.myAnsiEscapeDecoder.escapeText(text, outputType, this);
    }

    @Override
    public void coloredTextAvailable(@NotNull String text, @NotNull Key attributes) {
        super.notifyTextAvailable(text, attributes);
    }
}

