/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.FileFilter;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PathEnvironmentVariableUtil {
    private static final String PATH = "PATH";

    private PathEnvironmentVariableUtil() {
    }

    @Nullable
    public static File findInPath(@NotNull @NonNls String fileBaseName) {
        return PathEnvironmentVariableUtil.findInPath(fileBaseName, null);
    }

    @Nullable
    public static File findInPath(@NotNull String fileBaseName, @Nullable FileFilter filter) {
        return PathEnvironmentVariableUtil.findInPath(fileBaseName, PathEnvironmentVariableUtil.getPathVariableValue(), filter);
    }

    @Nullable
    public static File findInPath(@NotNull String fileBaseName, @Nullable String pathVariableValue, @Nullable FileFilter filter) {
        List<File> exeFiles = PathEnvironmentVariableUtil.findExeFilesInPath(true, filter, pathVariableValue, fileBaseName);
        return ContainerUtil.getFirstItem(exeFiles);
    }

    @NotNull
    public static List<File> findAllExeFilesInPath(@NotNull String fileBaseName) {
        return PathEnvironmentVariableUtil.findAllExeFilesInPath(fileBaseName, null);
    }

    @NotNull
    public static List<File> findAllExeFilesInPath(@NotNull String fileBaseName, @Nullable FileFilter filter) {
        return PathEnvironmentVariableUtil.findExeFilesInPath(false, filter, PathEnvironmentVariableUtil.getPathVariableValue(), fileBaseName);
    }

    @NotNull
    private static List<File> findExeFilesInPath(boolean stopAfterFirstMatch, @Nullable FileFilter filter, @Nullable String pathEnvVarValue, String ... fileBaseNames) {
        if (pathEnvVarValue == null) {
            return Collections.emptyList();
        }
        SmartList<File> result = new SmartList<File>();
        List<String> dirPaths = PathEnvironmentVariableUtil.getPathDirs(pathEnvVarValue);
        for (String dirPath : dirPaths) {
            File dir = new File(dirPath);
            if (!dir.isAbsolute() || !dir.isDirectory()) continue;
            for (String fileBaseName : fileBaseNames) {
                File exeFile = new File(dir, fileBaseName);
                if (!exeFile.isFile() || !exeFile.canExecute() || filter != null && !filter.accept(exeFile)) continue;
                result.add(exeFile);
                if (!stopAfterFirstMatch) continue;
                return result;
            }
        }
        return result;
    }

    @NotNull
    public static List<String> getPathDirs(@NotNull String pathEnvVarValue) {
        return StringUtil.split(pathEnvVarValue, File.pathSeparator, true, true);
    }

    @NotNull
    public static List<String> getWindowsExecutableFileExtensions() {
        String allExtensions;
        if (SystemInfo.isWindows && (allExtensions = System.getenv("PATHEXT")) != null) {
            List<String> extensions = StringUtil.split(allExtensions, ";", true, true);
            extensions = ContainerUtil.filter(extensions, s -> !StringUtil.isEmpty(s) && s.startsWith("."));
            return ContainerUtil.map2List(extensions, s -> StringUtil.toLowerCase(s));
        }
        return Collections.emptyList();
    }

    @NotNull
    public static String findExecutableInWindowsPath(@NotNull String exePath) {
        return PathEnvironmentVariableUtil.findExecutableInWindowsPath(exePath, exePath);
    }

    @Contract(value="_, !null -> !null")
    public static String findExecutableInWindowsPath(@NotNull String exePath, @Nullable String defaultPath) {
        if (SystemInfo.isWindows && !StringUtil.containsChar(exePath, '/') && !StringUtil.containsChar(exePath, '\\')) {
            List<String> executableFileExtensions = PathEnvironmentVariableUtil.getWindowsExecutableFileExtensions();
            String[] baseNames = ContainerUtil.map2Array(executableFileExtensions, String.class, s -> exePath + s);
            List<File> exeFiles = PathEnvironmentVariableUtil.findExeFilesInPath(true, null, PathEnvironmentVariableUtil.getPathVariableValue(), baseNames);
            File foundFile = ContainerUtil.getFirstItem(exeFiles);
            if (foundFile != null) {
                return foundFile.getAbsolutePath();
            }
        }
        return defaultPath;
    }

    @Nullable
    public static String getPathVariableValue() {
        return EnvironmentUtil.getValue(PATH);
    }

    @Nullable
    public static File findExecutableInPathOnAnyOS(@NotNull @NonNls String fileBaseName) {
        if (SystemInfo.isWindows) {
            String[] fileNames = ContainerUtil.map2Array(PathEnvironmentVariableUtil.getWindowsExecutableFileExtensions(), String.class, extension -> fileBaseName + extension);
            List<File> exeFiles = PathEnvironmentVariableUtil.findExeFilesInPath(true, null, PathEnvironmentVariableUtil.getPathVariableValue(), fileNames);
            return ContainerUtil.getFirstItem(exeFiles);
        }
        return PathEnvironmentVariableUtil.findInPath(fileBaseName);
    }
}

