/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.configurations.ParameterTargetValue;
import com.intellij.execution.configurations.ParameterTargetValuePart;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;

public class CompositeParameterTargetedValue {
    private final List<ParameterTargetValuePart> myValues = new ArrayList<ParameterTargetValuePart>();

    public CompositeParameterTargetedValue() {
    }

    public CompositeParameterTargetedValue(@NotNull String value) {
        this();
        this.addLocalPart(value);
    }

    @NotNull
    public CompositeParameterTargetedValue addLocalPart(@NotNull String value) {
        this.myValues.add(new ParameterTargetValuePart.Const(value));
        return this;
    }

    @NotNull
    public CompositeParameterTargetedValue addPathPart(@NotNull String localPath) {
        this.myValues.add(new ParameterTargetValuePart.Path(localPath));
        return this;
    }

    @NotNull
    public CompositeParameterTargetedValue addPathSeparator() {
        this.myValues.add(ParameterTargetValuePart.PathSeparator.INSTANCE);
        return this;
    }

    @NotNull
    public CompositeParameterTargetedValue addPathPart(@NotNull File file2) {
        this.myValues.add(new ParameterTargetValuePart.Path(file2));
        return this;
    }

    @NotNull
    public CompositeParameterTargetedValue addTargetPart(@NotNull String localValue, @NotNull Promise<String> remoteValue) {
        this.myValues.add(new ParameterTargetValuePart.PromiseValue(localValue, remoteValue));
        return this;
    }

    @NotNull
    public String getLocalValue() {
        if (this.myValues.isEmpty()) {
            return "";
        }
        if (this.myValues.size() == 1) {
            return this.myValues.get(0).getLocalValue();
        }
        StringBuilder value = new StringBuilder();
        for (ParameterTargetValue parameterTargetValue : this.myValues) {
            value.append(parameterTargetValue.getLocalValue());
        }
        return value.toString();
    }

    @NotNull
    public List<ParameterTargetValuePart> getParts() {
        return Collections.unmodifiableList(this.myValues);
    }

    public String toString() {
        if (this.myValues.isEmpty()) {
            return "";
        }
        if (this.myValues.size() == 1) {
            return this.myValues.get(0).toString();
        }
        return this.myValues.toString();
    }

    @NotNull
    @Contract(pure=true)
    public static Collection<? extends CompositeParameterTargetedValue> targetizeParameters(List<String> parameters) {
        return ContainerUtil.map(parameters, parameter -> new CompositeParameterTargetedValue((String)parameter));
    }
}

