/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import org.jetbrains.annotations.NotNull;

public enum Platform {
    WINDOWS('\\', ';', "\r\n"),
    UNIX('/', ':', "\n");

    public final char fileSeparator;
    public final char pathSeparator;
    @NotNull
    public final String lineSeparator;

    private Platform(@NotNull char fileSeparator, char pathSeparator, String lineSeparator) {
        this.fileSeparator = fileSeparator;
        this.pathSeparator = pathSeparator;
        this.lineSeparator = lineSeparator;
    }

    @NlsSafe
    @NotNull
    public static Platform current() {
        return SystemInfo.isWindows ? WINDOWS : UNIX;
    }

    @NotNull
    public String toSystemDependentName(@NotNull String filePath) {
        return FileUtil.toSystemDependentName((String)filePath, (char)this.fileSeparator);
    }
}

