/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Random;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class CommandLineWrapperUtil {
    public static final String CLASSPATH_JAR_FILE_NAME_PREFIX = "classpath";

    @NotNull
    public static File createClasspathJarFile(@NotNull Manifest manifest, @NotNull List<String> pathList) throws IOException {
        File file2 = FileUtil.createTempFile(CLASSPATH_JAR_FILE_NAME_PREFIX + Math.abs(new Random().nextInt(Integer.MAX_VALUE)), ".jar", true);
        CommandLineWrapperUtil.fillClasspathJarFile(manifest, pathList, false, file2);
        return file2;
    }

    public static void fillClasspathJarFile(Manifest manifest, List<String> pathList, boolean notEscape, @NotNull File outputJar) throws IOException {
        StringBuilder classPath = new StringBuilder();
        for (String path : pathList) {
            if (classPath.length() > 0) {
                classPath.append(' ');
            }
            File classpathElement = new File(path);
            String url = (notEscape ? classpathElement.toURL() : classpathElement.toURI().toURL()).toString();
            classPath.append(url);
        }
        CommandLineWrapperUtil.fillClasspathJarFile(manifest, classPath.toString(), outputJar);
    }

    public static void fillClasspathJarFile(Manifest manifest, String classPath, @NotNull File outputJar) throws IOException {
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        manifest.getMainAttributes().put(Attributes.Name.CLASS_PATH, classPath);
        new JarOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(outputJar)), manifest).close();
    }

    @NotNull
    public static File createArgumentFile(@NotNull List<String> args2, @NotNull Charset cs) throws IOException {
        File argFile = FileUtil.createTempFile("idea_arg_file" + new Random().nextInt(Integer.MAX_VALUE), null, true);
        CommandLineWrapperUtil.writeArgumentsFile(argFile, args2, cs);
        return argFile;
    }

    public static void writeArgumentsFile(@NotNull File argFile, @NotNull List<String> args2, @NotNull Charset cs) throws IOException {
        CommandLineWrapperUtil.writeArgumentsFile(argFile, args2, System.lineSeparator(), cs);
    }

    public static void writeArgumentsFile(@NotNull File argFile, @NotNull List<String> args2, String lineSeparator, @NotNull Charset cs) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(argFile), cs));){
            for (String arg2 : args2) {
                writer.write(CommandLineWrapperUtil.quoteArg(arg2));
                writer.write(lineSeparator);
            }
        }
    }

    private static String quoteArg(String arg2) {
        String specials = " #'\"\n\r\t\f";
        if (!StringUtil.containsAnyChar(arg2, specials)) {
            return arg2;
        }
        @NonNls StringBuilder sb = new StringBuilder(arg2.length() * 2);
        for (int i = 0; i < arg2.length(); ++i) {
            char c = arg2.charAt(i);
            if (c == ' ' || c == '#' || c == '\'') {
                sb.append('\"').append(c).append('\"');
                continue;
            }
            if (c == '\"') {
                sb.append("\"\\\"\"");
                continue;
            }
            if (c == '\n') {
                sb.append("\"\\n\"");
                continue;
            }
            if (c == '\r') {
                sb.append("\"\\r\"");
                continue;
            }
            if (c == '\t') {
                sb.append("\"\\t\"");
                continue;
            }
            if (c == '\f') {
                sb.append("\"\\f\"");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    @NotNull
    public static File createWrapperFile(@NotNull List<String> classpath, @NotNull Charset cs) throws IOException {
        File file2 = FileUtil.createTempFile(CLASSPATH_JAR_FILE_NAME_PREFIX + new Random().nextInt(Integer.MAX_VALUE), null, true);
        CommandLineWrapperUtil.writeWrapperFile(file2, classpath, System.lineSeparator(), cs);
        return file2;
    }

    public static void writeWrapperFile(@NotNull File wrapperFile, @NotNull List<String> classpath, @NotNull String lineSeparator, @NotNull Charset cs) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(wrapperFile), cs));){
            for (String path : classpath) {
                writer.write(path);
                writer.write(lineSeparator);
            }
        }
    }
}

